@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayResponse
import com.pulumi.azurenative.network.kotlin.outputs.ManagedRulesDefinitionResponse
import com.pulumi.azurenative.network.kotlin.outputs.PolicySettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.WebApplicationFirewallCustomRuleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayResponse.Companion.toKotlin as applicationGatewayResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ManagedRulesDefinitionResponse.Companion.toKotlin as managedRulesDefinitionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PolicySettingsResponse.Companion.toKotlin as policySettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.WebApplicationFirewallCustomRuleResponse.Companion.toKotlin as webApplicationFirewallCustomRuleResponseToKotlin

/**
 * Builder for [WebApplicationFirewallPolicy].
 */
@PulumiTagMarker
public class WebApplicationFirewallPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebApplicationFirewallPolicyArgs = WebApplicationFirewallPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebApplicationFirewallPolicyArgsBuilder.() -> Unit) {
        val builder = WebApplicationFirewallPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebApplicationFirewallPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.network.WebApplicationFirewallPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebApplicationFirewallPolicy(builtJavaResource)
    }
}

/**
 * Defines web application firewall policy.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Creates or updates a WAF policy within a resource group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webApplicationFirewallPolicy = new AzureNative.Network.WebApplicationFirewallPolicy("webApplicationFirewallPolicy", new()
 *     {
 *         CustomRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = AzureNative.Network.WebApplicationFirewallAction.Block,
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = AzureNative.Network.WebApplicationFirewallMatchVariable.RemoteAddr,
 *                             },
 *                         },
 *                         Operator = AzureNative.Network.WebApplicationFirewallOperator.IPMatch,
 *                     },
 *                 },
 *                 Name = "Rule1",
 *                 Priority = 1,
 *                 RuleType = AzureNative.Network.WebApplicationFirewallRuleType.MatchRule,
 *             },
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = AzureNative.Network.WebApplicationFirewallAction.Block,
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = AzureNative.Network.WebApplicationFirewallMatchVariable.RemoteAddr,
 *                             },
 *                         },
 *                         Operator = AzureNative.Network.WebApplicationFirewallOperator.IPMatch,
 *                     },
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "Windows",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 Selector = "UserAgent",
 *                                 VariableName = AzureNative.Network.WebApplicationFirewallMatchVariable.RequestHeaders,
 *                             },
 *                         },
 *                         Operator = AzureNative.Network.WebApplicationFirewallOperator.Contains,
 *                     },
 *                 },
 *                 Name = "Rule2",
 *                 Priority = 2,
 *                 RuleType = AzureNative.Network.WebApplicationFirewallRuleType.MatchRule,
 *             },
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = AzureNative.Network.WebApplicationFirewallAction.Block,
 *                 GroupByUserSession = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.GroupByUserSessionArgs
 *                     {
 *                         GroupByVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.GroupByVariableArgs
 *                             {
 *                                 VariableName = AzureNative.Network.ApplicationGatewayFirewallUserSessionVariable.ClientAddr,
 *                             },
 *                         },
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = AzureNative.Network.WebApplicationFirewallMatchVariable.RemoteAddr,
 *                             },
 *                         },
 *                         NegationConditon = true,
 *                         Operator = AzureNative.Network.WebApplicationFirewallOperator.IPMatch,
 *                     },
 *                 },
 *                 Name = "RateLimitRule3",
 *                 Priority = 3,
 *                 RateLimitDuration = AzureNative.Network.ApplicationGatewayFirewallRateLimitDuration.OneMin,
 *                 RateLimitThreshold = 10,
 *                 RuleType = AzureNative.Network.WebApplicationFirewallRuleType.RateLimitRule,
 *             },
 *         },
 *         Location = "WestUs",
 *         ManagedRules = new AzureNative.Network.Inputs.ManagedRulesDefinitionArgs
 *         {
 *             Exclusions = new[]
 *             {
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     ExclusionManagedRuleSets = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ExclusionManagedRuleSetArgs
 *                         {
 *                             RuleGroups = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ExclusionManagedRuleGroupArgs
 *                                 {
 *                                     RuleGroupName = "REQUEST-930-APPLICATION-ATTACK-LFI",
 *                                     Rules = new[]
 *                                     {
 *                                         new AzureNative.Network.Inputs.ExclusionManagedRuleArgs
 *                                         {
 *                                             RuleId = "930120",
 *                                         },
 *                                     },
 *                                 },
 *                                 new AzureNative.Network.Inputs.ExclusionManagedRuleGroupArgs
 *                                 {
 *                                     RuleGroupName = "REQUEST-932-APPLICATION-ATTACK-RCE",
 *                                 },
 *                             },
 *                             RuleSetType = "OWASP",
 *                             RuleSetVersion = "3.2",
 *                         },
 *                     },
 *                     MatchVariable = AzureNative.Network.OwaspCrsExclusionEntryMatchVariable.RequestArgNames,
 *                     Selector = "hello",
 *                     SelectorMatchOperator = AzureNative.Network.OwaspCrsExclusionEntrySelectorMatchOperator.StartsWith,
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     ExclusionManagedRuleSets = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ExclusionManagedRuleSetArgs
 *                         {
 *                             RuleGroups = new() { },
 *                             RuleSetType = "OWASP",
 *                             RuleSetVersion = "3.1",
 *                         },
 *                     },
 *                     MatchVariable = AzureNative.Network.OwaspCrsExclusionEntryMatchVariable.RequestArgNames,
 *                     Selector = "hello",
 *                     SelectorMatchOperator = AzureNative.Network.OwaspCrsExclusionEntrySelectorMatchOperator.EndsWith,
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     MatchVariable = AzureNative.Network.OwaspCrsExclusionEntryMatchVariable.RequestArgNames,
 *                     Selector = "test",
 *                     SelectorMatchOperator = AzureNative.Network.OwaspCrsExclusionEntrySelectorMatchOperator.StartsWith,
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     MatchVariable = AzureNative.Network.OwaspCrsExclusionEntryMatchVariable.RequestArgValues,
 *                     Selector = "test",
 *                     SelectorMatchOperator = AzureNative.Network.OwaspCrsExclusionEntrySelectorMatchOperator.StartsWith,
 *                 },
 *             },
 *             ManagedRuleSets = new[]
 *             {
 *                 new AzureNative.Network.Inputs.ManagedRuleSetArgs
 *                 {
 *                     RuleGroupOverrides = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ManagedRuleGroupOverrideArgs
 *                         {
 *                             RuleGroupName = "REQUEST-931-APPLICATION-ATTACK-RFI",
 *                             Rules = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = AzureNative.Network.ActionType.Log,
 *                                     RuleId = "931120",
 *                                     State = AzureNative.Network.ManagedRuleEnabledState.Enabled,
 *                                 },
 *                                 new AzureNative.Network.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = AzureNative.Network.ActionType.AnomalyScoring,
 *                                     RuleId = "931130",
 *                                     State = AzureNative.Network.ManagedRuleEnabledState.Disabled,
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RuleSetType = "OWASP",
 *                     RuleSetVersion = "3.2",
 *                 },
 *             },
 *         },
 *         PolicyName = "Policy1",
 *         PolicySettings = new AzureNative.Network.Inputs.PolicySettingsArgs
 *         {
 *             LogScrubbing = new AzureNative.Network.Inputs.PolicySettingsLogScrubbingArgs
 *             {
 *                 ScrubbingRules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.WebApplicationFirewallScrubbingRulesArgs
 *                     {
 *                         MatchVariable = AzureNative.Network.ScrubbingRuleEntryMatchVariable.RequestArgNames,
 *                         Selector = "test",
 *                         SelectorMatchOperator = AzureNative.Network.ScrubbingRuleEntryMatchOperator.EqualsValue,
 *                         State = AzureNative.Network.ScrubbingRuleEntryState.Enabled,
 *                     },
 *                     new AzureNative.Network.Inputs.WebApplicationFirewallScrubbingRulesArgs
 *                     {
 *                         MatchVariable = AzureNative.Network.ScrubbingRuleEntryMatchVariable.RequestIPAddress,
 *                         SelectorMatchOperator = AzureNative.Network.ScrubbingRuleEntryMatchOperator.EqualsAny,
 *                         State = AzureNative.Network.ScrubbingRuleEntryState.Enabled,
 *                     },
 *                 },
 *                 State = AzureNative.Network.WebApplicationFirewallScrubbingState.Enabled,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewWebApplicationFirewallPolicy(ctx, "webApplicationFirewallPolicy", &network.WebApplicationFirewallPolicyArgs{
 * 			CustomRules: network.WebApplicationFirewallCustomRuleArray{
 * 				&network.WebApplicationFirewallCustomRuleArgs{
 * 					Action: pulumi.String(network.WebApplicationFirewallActionBlock),
 * 					MatchConditions: network.MatchConditionArray{
 * 						&network.MatchConditionArgs{
 * 							MatchValues: pulumi.StringArray{
 * 								pulumi.String("192.168.1.0/24"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							MatchVariables: network.MatchVariableArray{
 * 								&network.MatchVariableArgs{
 * 									VariableName: pulumi.String(network.WebApplicationFirewallMatchVariableRemoteAddr),
 * 								},
 * 							},
 * 							Operator: pulumi.String(network.WebApplicationFirewallOperatorIPMatch),
 * 						},
 * 					},
 * 					Name:     pulumi.String("Rule1"),
 * 					Priority: pulumi.Int(1),
 * 					RuleType: pulumi.String(network.WebApplicationFirewallRuleTypeMatchRule),
 * 				},
 * 				&network.WebApplicationFirewallCustomRuleArgs{
 * 					Action: pulumi.String(network.WebApplicationFirewallActionBlock),
 * 					MatchConditions: network.MatchConditionArray{
 * 						&network.MatchConditionArgs{
 * 							MatchValues: pulumi.StringArray{
 * 								pulumi.String("192.168.1.0/24"),
 * 							},
 * 							MatchVariables: network.MatchVariableArray{
 * 								&network.MatchVariableArgs{
 * 									VariableName: pulumi.String(network.WebApplicationFirewallMatchVariableRemoteAddr),
 * 								},
 * 							},
 * 							Operator: pulumi.String(network.WebApplicationFirewallOperatorIPMatch),
 * 						},
 * 						&network.MatchConditionArgs{
 * 							MatchValues: pulumi.StringArray{
 * 								pulumi.String("Windows"),
 * 							},
 * 							MatchVariables: network.MatchVariableArray{
 * 								&network.MatchVariableArgs{
 * 									Selector:     pulumi.String("UserAgent"),
 * 									VariableName: pulumi.String(network.WebApplicationFirewallMatchVariableRequestHeaders),
 * 								},
 * 							},
 * 							Operator: pulumi.String(network.WebApplicationFirewallOperatorContains),
 * 						},
 * 					},
 * 					Name:     pulumi.String("Rule2"),
 * 					Priority: pulumi.Int(2),
 * 					RuleType: pulumi.String(network.WebApplicationFirewallRuleTypeMatchRule),
 * 				},
 * 				&network.WebApplicationFirewallCustomRuleArgs{
 * 					Action: pulumi.String(network.WebApplicationFirewallActionBlock),
 * 					GroupByUserSession: network.GroupByUserSessionArray{
 * 						&network.GroupByUserSessionArgs{
 * 							GroupByVariables: network.GroupByVariableArray{
 * 								&network.GroupByVariableArgs{
 * 									VariableName: pulumi.String(network.ApplicationGatewayFirewallUserSessionVariableClientAddr),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					MatchConditions: network.MatchConditionArray{
 * 						&network.MatchConditionArgs{
 * 							MatchValues: pulumi.StringArray{
 * 								pulumi.String("192.168.1.0/24"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							MatchVariables: network.MatchVariableArray{
 * 								&network.MatchVariableArgs{
 * 									VariableName: pulumi.String(network.WebApplicationFirewallMatchVariableRemoteAddr),
 * 								},
 * 							},
 * 							NegationConditon: pulumi.Bool(true),
 * 							Operator:         pulumi.String(network.WebApplicationFirewallOperatorIPMatch),
 * 						},
 * 					},
 * 					Name:               pulumi.String("RateLimitRule3"),
 * 					Priority:           pulumi.Int(3),
 * 					RateLimitDuration:  pulumi.String(network.ApplicationGatewayFirewallRateLimitDurationOneMin),
 * 					RateLimitThreshold: pulumi.Int(10),
 * 					RuleType:           pulumi.String(network.WebApplicationFirewallRuleTypeRateLimitRule),
 * 				},
 * 			},
 * 			Location: pulumi.String("WestUs"),
 * 			ManagedRules: &network.ManagedRulesDefinitionArgs{
 * 				Exclusions: network.OwaspCrsExclusionEntryArray{
 * 					&network.OwaspCrsExclusionEntryArgs{
 * 						ExclusionManagedRuleSets: network.ExclusionManagedRuleSetArray{
 * 							&network.ExclusionManagedRuleSetArgs{
 * 								RuleGroups: network.ExclusionManagedRuleGroupArray{
 * 									&network.ExclusionManagedRuleGroupArgs{
 * 										RuleGroupName: pulumi.String("REQUEST-930-APPLICATION-ATTACK-LFI"),
 * 										Rules: network.ExclusionManagedRuleArray{
 * 											&network.ExclusionManagedRuleArgs{
 * 												RuleId: pulumi.String("930120"),
 * 											},
 * 										},
 * 									},
 * 									&network.ExclusionManagedRuleGroupArgs{
 * 										RuleGroupName: pulumi.String("REQUEST-932-APPLICATION-ATTACK-RCE"),
 * 									},
 * 								},
 * 								RuleSetType:    pulumi.String("OWASP"),
 * 								RuleSetVersion: pulumi.String("3.2"),
 * 							},
 * 						},
 * 						MatchVariable:         pulumi.String(network.OwaspCrsExclusionEntryMatchVariableRequestArgNames),
 * 						Selector:              pulumi.String("hello"),
 * 						SelectorMatchOperator: pulumi.String(network.OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith),
 * 					},
 * 					&network.OwaspCrsExclusionEntryArgs{
 * 						ExclusionManagedRuleSets: network.ExclusionManagedRuleSetArray{
 * 							&network.ExclusionManagedRuleSetArgs{
 * 								RuleGroups:     network.ExclusionManagedRuleGroupArray{},
 * 								RuleSetType:    pulumi.String("OWASP"),
 * 								RuleSetVersion: pulumi.String("3.1"),
 * 							},
 * 						},
 * 						MatchVariable:         pulumi.String(network.OwaspCrsExclusionEntryMatchVariableRequestArgNames),
 * 						Selector:              pulumi.String("hello"),
 * 						SelectorMatchOperator: pulumi.String(network.OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith),
 * 					},
 * 					&network.OwaspCrsExclusionEntryArgs{
 * 						MatchVariable:         pulumi.String(network.OwaspCrsExclusionEntryMatchVariableRequestArgNames),
 * 						Selector:              pulumi.String("test"),
 * 						SelectorMatchOperator: pulumi.String(network.OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith),
 * 					},
 * 					&network.OwaspCrsExclusionEntryArgs{
 * 						MatchVariable:         pulumi.String(network.OwaspCrsExclusionEntryMatchVariableRequestArgValues),
 * 						Selector:              pulumi.String("test"),
 * 						SelectorMatchOperator: pulumi.String(network.OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith),
 * 					},
 * 				},
 * 				ManagedRuleSets: network.ManagedRuleSetArray{
 * 					&network.ManagedRuleSetArgs{
 * 						RuleGroupOverrides: network.ManagedRuleGroupOverrideArray{
 * 							&network.ManagedRuleGroupOverrideArgs{
 * 								RuleGroupName: pulumi.String("REQUEST-931-APPLICATION-ATTACK-RFI"),
 * 								Rules: network.ManagedRuleOverrideArray{
 * 									&network.ManagedRuleOverrideArgs{
 * 										Action: pulumi.String(network.ActionTypeLog),
 * 										RuleId: pulumi.String("931120"),
 * 										State:  pulumi.String(network.ManagedRuleEnabledStateEnabled),
 * 									},
 * 									&network.ManagedRuleOverrideArgs{
 * 										Action: pulumi.String(network.ActionTypeAnomalyScoring),
 * 										RuleId: pulumi.String("931130"),
 * 										State:  pulumi.String(network.ManagedRuleEnabledStateDisabled),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						RuleSetType:    pulumi.String("OWASP"),
 * 						RuleSetVersion: pulumi.String("3.2"),
 * 					},
 * 				},
 * 			},
 * 			PolicyName: pulumi.String("Policy1"),
 * 			PolicySettings: &network.PolicySettingsArgs{
 * 				LogScrubbing: &network.PolicySettingsLogScrubbingArgs{
 * 					ScrubbingRules: network.WebApplicationFirewallScrubbingRulesArray{
 * 						&network.WebApplicationFirewallScrubbingRulesArgs{
 * 							MatchVariable:         pulumi.String(network.ScrubbingRuleEntryMatchVariableRequestArgNames),
 * 							Selector:              pulumi.String("test"),
 * 							SelectorMatchOperator: pulumi.String(network.ScrubbingRuleEntryMatchOperatorEquals),
 * 							State:                 pulumi.String(network.ScrubbingRuleEntryStateEnabled),
 * 						},
 * 						&network.WebApplicationFirewallScrubbingRulesArgs{
 * 							MatchVariable:         pulumi.String(network.ScrubbingRuleEntryMatchVariableRequestIPAddress),
 * 							SelectorMatchOperator: pulumi.String(network.ScrubbingRuleEntryMatchOperatorEqualsAny),
 * 							State:                 pulumi.String(network.ScrubbingRuleEntryStateEnabled),
 * 						},
 * 					},
 * 					State: pulumi.String(network.WebApplicationFirewallScrubbingStateEnabled),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.WebApplicationFirewallPolicy;
 * import com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs;
 * import com.pulumi.azurenative.network.inputs.WebApplicationFirewallCustomRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ManagedRulesDefinitionArgs;
 * import com.pulumi.azurenative.network.inputs.PolicySettingsArgs;
 * import com.pulumi.azurenative.network.inputs.PolicySettingsLogScrubbingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webApplicationFirewallPolicy = new WebApplicationFirewallPolicy("webApplicationFirewallPolicy", WebApplicationFirewallPolicyArgs.builder()
 *             .customRules(
 *                 WebApplicationFirewallCustomRuleArgs.builder()
 *                     .action("Block")
 *                     .matchConditions(MatchConditionArgs.builder()
 *                         .matchValues(
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24")
 *                         .matchVariables(MatchVariableArgs.builder()
 *                             .variableName("RemoteAddr")
 *                             .build())
 *                         .operator("IPMatch")
 *                         .build())
 *                     .name("Rule1")
 *                     .priority(1)
 *                     .ruleType("MatchRule")
 *                     .build(),
 *                 WebApplicationFirewallCustomRuleArgs.builder()
 *                     .action("Block")
 *                     .matchConditions(
 *                         MatchConditionArgs.builder()
 *                             .matchValues("192.168.1.0/24")
 *                             .matchVariables(MatchVariableArgs.builder()
 *                                 .variableName("RemoteAddr")
 *                                 .build())
 *                             .operator("IPMatch")
 *                             .build(),
 *                         MatchConditionArgs.builder()
 *                             .matchValues("Windows")
 *                             .matchVariables(MatchVariableArgs.builder()
 *                                 .selector("UserAgent")
 *                                 .variableName("RequestHeaders")
 *                                 .build())
 *                             .operator("Contains")
 *                             .build())
 *                     .name("Rule2")
 *                     .priority(2)
 *                     .ruleType("MatchRule")
 *                     .build(),
 *                 WebApplicationFirewallCustomRuleArgs.builder()
 *                     .action("Block")
 *                     .groupByUserSession(GroupByUserSessionArgs.builder()
 *                         .groupByVariables(GroupByVariableArgs.builder()
 *                             .variableName("ClientAddr")
 *                             .build())
 *                         .build())
 *                     .matchConditions(MatchConditionArgs.builder()
 *                         .matchValues(
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24")
 *                         .matchVariables(MatchVariableArgs.builder()
 *                             .variableName("RemoteAddr")
 *                             .build())
 *                         .negationConditon(true)
 *                         .operator("IPMatch")
 *                         .build())
 *                     .name("RateLimitRule3")
 *                     .priority(3)
 *                     .rateLimitDuration("OneMin")
 *                     .rateLimitThreshold(10)
 *                     .ruleType("RateLimitRule")
 *                     .build())
 *             .location("WestUs")
 *             .managedRules(ManagedRulesDefinitionArgs.builder()
 *                 .exclusions(
 *                     OwaspCrsExclusionEntryArgs.builder()
 *                         .exclusionManagedRuleSets(ExclusionManagedRuleSetArgs.builder()
 *                             .ruleGroups(
 *                                 ExclusionManagedRuleGroupArgs.builder()
 *                                     .ruleGroupName("REQUEST-930-APPLICATION-ATTACK-LFI")
 *                                     .rules(ExclusionManagedRuleArgs.builder()
 *                                         .ruleId("930120")
 *                                         .build())
 *                                     .build(),
 *                                 ExclusionManagedRuleGroupArgs.builder()
 *                                     .ruleGroupName("REQUEST-932-APPLICATION-ATTACK-RCE")
 *                                     .build())
 *                             .ruleSetType("OWASP")
 *                             .ruleSetVersion("3.2")
 *                             .build())
 *                         .matchVariable("RequestArgNames")
 *                         .selector("hello")
 *                         .selectorMatchOperator("StartsWith")
 *                         .build(),
 *                     OwaspCrsExclusionEntryArgs.builder()
 *                         .exclusionManagedRuleSets(ExclusionManagedRuleSetArgs.builder()
 *                             .ruleGroups()
 *                             .ruleSetType("OWASP")
 *                             .ruleSetVersion("3.1")
 *                             .build())
 *                         .matchVariable("RequestArgNames")
 *                         .selector("hello")
 *                         .selectorMatchOperator("EndsWith")
 *                         .build(),
 *                     OwaspCrsExclusionEntryArgs.builder()
 *                         .matchVariable("RequestArgNames")
 *                         .selector("test")
 *                         .selectorMatchOperator("StartsWith")
 *                         .build(),
 *                     OwaspCrsExclusionEntryArgs.builder()
 *                         .matchVariable("RequestArgValues")
 *                         .selector("test")
 *                         .selectorMatchOperator("StartsWith")
 *                         .build())
 *                 .managedRuleSets(ManagedRuleSetArgs.builder()
 *                     .ruleGroupOverrides(ManagedRuleGroupOverrideArgs.builder()
 *                         .ruleGroupName("REQUEST-931-APPLICATION-ATTACK-RFI")
 *                         .rules(
 *                             ManagedRuleOverrideArgs.builder()
 *                                 .action("Log")
 *                                 .ruleId("931120")
 *                                 .state("Enabled")
 *                                 .build(),
 *                             ManagedRuleOverrideArgs.builder()
 *                                 .action("AnomalyScoring")
 *                                 .ruleId("931130")
 *                                 .state("Disabled")
 *                                 .build())
 *                         .build())
 *                     .ruleSetType("OWASP")
 *                     .ruleSetVersion("3.2")
 *                     .build())
 *                 .build())
 *             .policyName("Policy1")
 *             .policySettings(PolicySettingsArgs.builder()
 *                 .logScrubbing(PolicySettingsLogScrubbingArgs.builder()
 *                     .scrubbingRules(
 *                         WebApplicationFirewallScrubbingRulesArgs.builder()
 *                             .matchVariable("RequestArgNames")
 *                             .selector("test")
 *                             .selectorMatchOperator("Equals")
 *                             .state("Enabled")
 *                             .build(),
 *                         WebApplicationFirewallScrubbingRulesArgs.builder()
 *                             .matchVariable("RequestIPAddress")
 *                             .selectorMatchOperator("EqualsAny")
 *                             .state("Enabled")
 *                             .build())
 *                     .state("Enabled")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:WebApplicationFirewallPolicy Policy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}
 * ```
 */
public class WebApplicationFirewallPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.network.WebApplicationFirewallPolicy,
) : KotlinCustomResource(javaResource, WebApplicationFirewallPolicyMapper) {
    /**
     * A collection of references to application gateways.
     */
    public val applicationGateways: Output<List<ApplicationGatewayResponse>>
        get() = javaResource.applicationGateways().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationGatewayResponseToKotlin(args0) })
            })
        })

    /**
     * The custom rules inside the policy.
     */
    public val customRules: Output<List<WebApplicationFirewallCustomRuleResponse>>?
        get() = javaResource.customRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        webApplicationFirewallCustomRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A collection of references to application gateway http listeners.
     */
    public val httpListeners: Output<List<SubResourceResponse>>
        get() = javaResource.httpListeners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes the managedRules structure.
     */
    public val managedRules: Output<ManagedRulesDefinitionResponse>
        get() = javaResource.managedRules().applyValue({ args0 ->
            args0.let({ args0 ->
                managedRulesDefinitionResponseToKotlin(args0)
            })
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A collection of references to application gateway path rules.
     */
    public val pathBasedRules: Output<List<SubResourceResponse>>
        get() = javaResource.pathBasedRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The PolicySettings for policy.
     */
    public val policySettings: Output<PolicySettingsResponse>?
        get() = javaResource.policySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policySettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioning state of the web application firewall policy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource status of the policy.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebApplicationFirewallPolicyMapper : ResourceMapper<WebApplicationFirewallPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.WebApplicationFirewallPolicy::class == javaResource::class

    override fun map(javaResource: Resource): WebApplicationFirewallPolicy =
        WebApplicationFirewallPolicy(
            javaResource as
                com.pulumi.azurenative.network.WebApplicationFirewallPolicy,
        )
}

/**
 * @see [WebApplicationFirewallPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebApplicationFirewallPolicy].
 */
public suspend fun webApplicationFirewallPolicy(
    name: String,
    block: suspend WebApplicationFirewallPolicyResourceBuilder.() -> Unit,
):
    WebApplicationFirewallPolicy {
    val builder = WebApplicationFirewallPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebApplicationFirewallPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webApplicationFirewallPolicy(name: String): WebApplicationFirewallPolicy {
    val builder = WebApplicationFirewallPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
