@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Zone].
 */
@PulumiTagMarker
public class ZoneResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ZoneArgs = ZoneArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ZoneArgsBuilder.() -> Unit) {
        val builder = ZoneArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Zone {
        val builtJavaResource = com.pulumi.azurenative.network.Zone(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Zone(builtJavaResource)
    }
}

/**
 * Describes a DNS zone.
 * Azure REST API version: 2018-05-01. Prior API version in Azure Native 1.x: 2018-05-01.
 * Other available API versions: 2015-05-04-preview, 2016-04-01, 2023-07-01-preview.
 * ## Example Usage
 * ### Create zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var zone = new AzureNative.Network.Zone("zone", new()
 *     {
 *         Location = "Global",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewZone(ctx, "zone", &network.ZoneArgs{
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ZoneName: pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Zone;
 * import com.pulumi.azurenative.network.ZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var zone = new Zone("zone", ZoneArgs.builder()
 *             .location("Global")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Zone zone1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}
 * ```
 */
public class Zone internal constructor(
    override val javaResource: com.pulumi.azurenative.network.Zone,
) : KotlinCustomResource(javaResource, ZoneMapper) {
    /**
     * The etag of the zone.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The maximum number of record sets that can be created in this DNS zone.  This is a read-only property and any attempt to set this value will be ignored.
     */
    public val maxNumberOfRecordSets: Output<Double>
        get() = javaResource.maxNumberOfRecordSets().applyValue({ args0 -> args0 })

    /**
     * The maximum number of records per record set that can be created in this DNS zone.  This is a read-only property and any attempt to set this value will be ignored.
     */
    public val maxNumberOfRecordsPerRecordSet: Output<Double>
        get() = javaResource.maxNumberOfRecordsPerRecordSet().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name servers for this DNS zone. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val nameServers: Output<List<String>>
        get() = javaResource.nameServers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The current number of record sets in this DNS zone.  This is a read-only property and any attempt to set this value will be ignored.
     */
    public val numberOfRecordSets: Output<Double>
        get() = javaResource.numberOfRecordSets().applyValue({ args0 -> args0 })

    /**
     * A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
     */
    public val registrationVirtualNetworks: Output<List<SubResourceResponse>>?
        get() = javaResource.registrationVirtualNetworks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
     */
    public val resolutionVirtualNetworks: Output<List<SubResourceResponse>>?
        get() = javaResource.resolutionVirtualNetworks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The type of this DNS zone (Public or Private).
     */
    public val zoneType: Output<String>?
        get() = javaResource.zoneType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ZoneMapper : ResourceMapper<Zone> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.Zone::class == javaResource::class

    override fun map(javaResource: Resource): Zone = Zone(
        javaResource as
            com.pulumi.azurenative.network.Zone,
    )
}

/**
 * @see [Zone].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Zone].
 */
public suspend fun zone(name: String, block: suspend ZoneResourceBuilder.() -> Unit): Zone {
    val builder = ZoneResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Zone].
 * @param name The _unique_ name of the resulting resource.
 */
public fun zone(name: String): Zone {
    val builder = ZoneResourceBuilder()
    builder.name(name)
    return builder.build()
}
