@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
 */
public enum class BackendEnabledState(
    public val javaValue: com.pulumi.azurenative.network.enums.BackendEnabledState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.BackendEnabledState> {
    Enabled(com.pulumi.azurenative.network.enums.BackendEnabledState.Enabled),
    Disabled(com.pulumi.azurenative.network.enums.BackendEnabledState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.BackendEnabledState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.BackendEnabledState):
            BackendEnabledState = BackendEnabledState.values().first { it.javaValue == javaType }
    }
}
