@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
 */
public enum class FrontDoorEnabledState(
    public val javaValue: com.pulumi.azurenative.network.enums.FrontDoorEnabledState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.FrontDoorEnabledState> {
    Enabled(com.pulumi.azurenative.network.enums.FrontDoorEnabledState.Enabled),
    Disabled(com.pulumi.azurenative.network.enums.FrontDoorEnabledState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.FrontDoorEnabledState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.FrontDoorEnabledState):
            FrontDoorEnabledState = FrontDoorEnabledState.values().first { it.javaValue == javaType }
    }
}
