@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The IPSec encryption algorithm (IKE phase 1).
 */
public enum class IpsecEncryption(
    public val javaValue: com.pulumi.azurenative.network.enums.IpsecEncryption,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.IpsecEncryption> {
    None(com.pulumi.azurenative.network.enums.IpsecEncryption.None),
    DES(com.pulumi.azurenative.network.enums.IpsecEncryption.DES),
    DES3(com.pulumi.azurenative.network.enums.IpsecEncryption.DES3),
    AES128(com.pulumi.azurenative.network.enums.IpsecEncryption.AES128),
    AES192(com.pulumi.azurenative.network.enums.IpsecEncryption.AES192),
    AES256(com.pulumi.azurenative.network.enums.IpsecEncryption.AES256),
    GCMAES128(com.pulumi.azurenative.network.enums.IpsecEncryption.GCMAES128),
    GCMAES192(com.pulumi.azurenative.network.enums.IpsecEncryption.GCMAES192),
    GCMAES256(com.pulumi.azurenative.network.enums.IpsecEncryption.GCMAES256),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.IpsecEncryption = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.IpsecEncryption):
            IpsecEncryption = IpsecEncryption.values().first { it.javaValue == javaType }
    }
}
