@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
 */
public enum class MonitorProtocol(
    public val javaValue: com.pulumi.azurenative.network.enums.MonitorProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.MonitorProtocol> {
    HTTP(com.pulumi.azurenative.network.enums.MonitorProtocol.HTTP),
    HTTPS(com.pulumi.azurenative.network.enums.MonitorProtocol.HTTPS),
    TCP(com.pulumi.azurenative.network.enums.MonitorProtocol.TCP),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.MonitorProtocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.MonitorProtocol):
            MonitorProtocol = MonitorProtocol.values().first { it.javaValue == javaType }
    }
}
