@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Auxiliary mode of Network Interface resource.
 */
public enum class NetworkInterfaceAuxiliaryMode(
    public val javaValue: com.pulumi.azurenative.network.enums.NetworkInterfaceAuxiliaryMode,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.NetworkInterfaceAuxiliaryMode> {
    None(com.pulumi.azurenative.network.enums.NetworkInterfaceAuxiliaryMode.None),
    MaxConnections(com.pulumi.azurenative.network.enums.NetworkInterfaceAuxiliaryMode.MaxConnections),
    Floating(com.pulumi.azurenative.network.enums.NetworkInterfaceAuxiliaryMode.Floating),
    AcceleratedConnections(com.pulumi.azurenative.network.enums.NetworkInterfaceAuxiliaryMode.AcceleratedConnections),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.NetworkInterfaceAuxiliaryMode =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.enums.NetworkInterfaceAuxiliaryMode):
            NetworkInterfaceAuxiliaryMode =
            NetworkInterfaceAuxiliaryMode.values().first { it.javaValue == javaType }
    }
}
