@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
 */
public enum class PreferredIPVersion(
    public val javaValue: com.pulumi.azurenative.network.enums.PreferredIPVersion,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.PreferredIPVersion> {
    IPv4(com.pulumi.azurenative.network.enums.PreferredIPVersion.IPv4),
    IPv6(com.pulumi.azurenative.network.enums.PreferredIPVersion.IPv6),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.PreferredIPVersion = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.PreferredIPVersion):
            PreferredIPVersion = PreferredIPVersion.values().first { it.javaValue == javaType }
    }
}
