@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The profile-level monitoring status of the Traffic Manager profile.
 */
public enum class ProfileMonitorStatus(
    public val javaValue: com.pulumi.azurenative.network.enums.ProfileMonitorStatus,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.ProfileMonitorStatus> {
    CheckingEndpoints(com.pulumi.azurenative.network.enums.ProfileMonitorStatus.CheckingEndpoints),
    Online(com.pulumi.azurenative.network.enums.ProfileMonitorStatus.Online),
    Degraded(com.pulumi.azurenative.network.enums.ProfileMonitorStatus.Degraded),
    Disabled(com.pulumi.azurenative.network.enums.ProfileMonitorStatus.Disabled),
    Inactive(com.pulumi.azurenative.network.enums.ProfileMonitorStatus.Inactive),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.ProfileMonitorStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.ProfileMonitorStatus):
            ProfileMonitorStatus = ProfileMonitorStatus.values().first { it.javaValue == javaType }
    }
}
