@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
 */
public enum class SessionAffinityEnabledState(
    public val javaValue: com.pulumi.azurenative.network.enums.SessionAffinityEnabledState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.SessionAffinityEnabledState> {
    Enabled(com.pulumi.azurenative.network.enums.SessionAffinityEnabledState.Enabled),
    Disabled(com.pulumi.azurenative.network.enums.SessionAffinityEnabledState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.SessionAffinityEnabledState =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.SessionAffinityEnabledState):
            SessionAffinityEnabledState =
            SessionAffinityEnabledState.values().first { it.javaValue == javaType }
    }
}
