@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gateway connection type.
 */
public enum class VirtualNetworkGatewayConnectionType(
    public val javaValue: com.pulumi.azurenative.network.enums.VirtualNetworkGatewayConnectionType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.VirtualNetworkGatewayConnectionType> {
    IPsec(com.pulumi.azurenative.network.enums.VirtualNetworkGatewayConnectionType.IPsec),
    Vnet2Vnet(com.pulumi.azurenative.network.enums.VirtualNetworkGatewayConnectionType.Vnet2Vnet),
    ExpressRoute(com.pulumi.azurenative.network.enums.VirtualNetworkGatewayConnectionType.ExpressRoute),
    VPNClient(com.pulumi.azurenative.network.enums.VirtualNetworkGatewayConnectionType.VPNClient),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.VirtualNetworkGatewayConnectionType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.enums.VirtualNetworkGatewayConnectionType):
            VirtualNetworkGatewayConnectionType =
            VirtualNetworkGatewayConnectionType.values().first { it.javaValue == javaType }
    }
}
