@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ActionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.RouteMapActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Action to be taken on a route matching a RouteMap criterion.
 * @property parameters List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN numbers to be added
 * @property type Type of action to be taken. Supported types are 'Remove', 'Add', 'Replace', and 'Drop.'
 */
public data class ActionArgs(
    public val parameters: Output<List<ParameterArgs>>? = null,
    public val type: Output<Either<String, RouteMapActionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ActionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ActionArgs =
        com.pulumi.azurenative.network.inputs.ActionArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ActionArgs].
 */
@PulumiTagMarker
public class ActionArgsBuilder internal constructor() {
    private var parameters: Output<List<ParameterArgs>>? = null

    private var type: Output<Either<String, RouteMapActionType>>? = null

    /**
     * @param value List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN numbers to be added
     */
    @JvmName("ncusvwmtjeopfawj")
    public suspend fun parameters(`value`: Output<List<ParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("ggqsqhkcxdwalnbc")
    public suspend fun parameters(vararg values: Output<ParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN numbers to be added
     */
    @JvmName("bgrhxgsiofxnsrmd")
    public suspend fun parameters(values: List<Output<ParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Type of action to be taken. Supported types are 'Remove', 'Add', 'Replace', and 'Drop.'
     */
    @JvmName("nticcfsjyxxvbxye")
    public suspend fun type(`value`: Output<Either<String, RouteMapActionType>>) {
        this.type = value
    }

    /**
     * @param value List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN numbers to be added
     */
    @JvmName("jnlbxrrqdeqcmevj")
    public suspend fun parameters(`value`: List<ParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN numbers to be added
     */
    @JvmName("cqgnuponnaifqduq")
    public suspend fun parameters(argument: List<suspend ParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ParameterArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN numbers to be added
     */
    @JvmName("kgattnlkrfbxlgkc")
    public suspend fun parameters(vararg argument: suspend ParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ParameterArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN numbers to be added
     */
    @JvmName("etoxxmkkebagswww")
    public suspend fun parameters(argument: suspend ParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN numbers to be added
     */
    @JvmName("mdjxiwattlepsiid")
    public suspend fun parameters(vararg values: ParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of action to be taken. Supported types are 'Remove', 'Add', 'Replace', and 'Drop.'
     */
    @JvmName("efxxpixjnxcnuxab")
    public suspend fun type(`value`: Either<String, RouteMapActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of action to be taken. Supported types are 'Remove', 'Add', 'Replace', and 'Drop.'
     */
    @JvmName("rvvargqitvkiketk")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RouteMapActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of action to be taken. Supported types are 'Remove', 'Add', 'Replace', and 'Drop.'
     */
    @JvmName("cmxpcfrdwhfimmuo")
    public fun type(`value`: RouteMapActionType) {
        val toBeMapped = Either.ofRight<String, RouteMapActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ActionArgs = ActionArgs(
        parameters = parameters,
        type = type,
    )
}
