@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayAuthenticationCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authentication certificates of an application gateway.
 * @property data Certificate public data.
 * @property id Resource ID.
 * @property name Name of the authentication certificate that is unique within an Application Gateway.
 */
public data class ApplicationGatewayAuthenticationCertificateArgs(
    public val `data`: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayAuthenticationCertificateArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayAuthenticationCertificateArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayAuthenticationCertificateArgs.builder()
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayAuthenticationCertificateArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayAuthenticationCertificateArgsBuilder internal constructor() {
    private var `data`: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Certificate public data.
     */
    @JvmName("gdhsdrpiajwndcks")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qlavektrutelplso")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the authentication certificate that is unique within an Application Gateway.
     */
    @JvmName("xsrphvsxeerxwrfo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Certificate public data.
     */
    @JvmName("mvayxpndrmwifhus")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("sraxijmewlrrlxbb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the authentication certificate that is unique within an Application Gateway.
     */
    @JvmName("treaqwuyuxtmagev")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ApplicationGatewayAuthenticationCertificateArgs =
        ApplicationGatewayAuthenticationCertificateArgs(
            `data` = `data`,
            id = id,
            name = name,
        )
}
