@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayConnectionDrainingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.
 * @property drainTimeoutInSec The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
 * @property enabled Whether connection draining is enabled or not.
 */
public data class ApplicationGatewayConnectionDrainingArgs(
    public val drainTimeoutInSec: Output<Int>,
    public val enabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayConnectionDrainingArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayConnectionDrainingArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayConnectionDrainingArgs.builder()
            .drainTimeoutInSec(drainTimeoutInSec.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayConnectionDrainingArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayConnectionDrainingArgsBuilder internal constructor() {
    private var drainTimeoutInSec: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
     */
    @JvmName("vmtlkkycvosrkabn")
    public suspend fun drainTimeoutInSec(`value`: Output<Int>) {
        this.drainTimeoutInSec = value
    }

    /**
     * @param value Whether connection draining is enabled or not.
     */
    @JvmName("kaulabuciqovvfvn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
     */
    @JvmName("xkeonvrndiqtafqu")
    public suspend fun drainTimeoutInSec(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.drainTimeoutInSec = mapped
    }

    /**
     * @param value Whether connection draining is enabled or not.
     */
    @JvmName("aifjyguaioovqiea")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ApplicationGatewayConnectionDrainingArgs =
        ApplicationGatewayConnectionDrainingArgs(
            drainTimeoutInSec = drainTimeoutInSec ?: throw PulumiNullFieldException("drainTimeoutInSec"),
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
