@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayFirewallDisabledRuleGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Allows to disable rules within a rule group or an entire rule group.
 * @property ruleGroupName The name of the rule group that will be disabled.
 * @property rules The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
 */
public data class ApplicationGatewayFirewallDisabledRuleGroupArgs(
    public val ruleGroupName: Output<String>,
    public val rules: Output<List<Int>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayFirewallDisabledRuleGroupArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayFirewallDisabledRuleGroupArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayFirewallDisabledRuleGroupArgs.builder()
            .ruleGroupName(ruleGroupName.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApplicationGatewayFirewallDisabledRuleGroupArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayFirewallDisabledRuleGroupArgsBuilder internal constructor() {
    private var ruleGroupName: Output<String>? = null

    private var rules: Output<List<Int>>? = null

    /**
     * @param value The name of the rule group that will be disabled.
     */
    @JvmName("ihhouwixqlylyxke")
    public suspend fun ruleGroupName(`value`: Output<String>) {
        this.ruleGroupName = value
    }

    /**
     * @param value The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
     */
    @JvmName("shehkmowwifwjfct")
    public suspend fun rules(`value`: Output<List<Int>>) {
        this.rules = value
    }

    @JvmName("txblrxnndlpmpxif")
    public suspend fun rules(vararg values: Output<Int>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
     */
    @JvmName("jhrtseehcmupecik")
    public suspend fun rules(values: List<Output<Int>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The name of the rule group that will be disabled.
     */
    @JvmName("ffouxehspoytqyml")
    public suspend fun ruleGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleGroupName = mapped
    }

    /**
     * @param value The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
     */
    @JvmName("cpcwvbdyivxgtyjc")
    public suspend fun rules(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param values The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
     */
    @JvmName("usppdsycupwpkqbd")
    public suspend fun rules(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): ApplicationGatewayFirewallDisabledRuleGroupArgs =
        ApplicationGatewayFirewallDisabledRuleGroupArgs(
            ruleGroupName = ruleGroupName ?: throw PulumiNullFieldException("ruleGroupName"),
            rules = rules,
        )
}
