@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayFirewallExclusionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allow to exclude some variable satisfy the condition for the WAF check.
 * @property matchVariable The variable to be excluded.
 * @property selector When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
 * @property selectorMatchOperator When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
 */
public data class ApplicationGatewayFirewallExclusionArgs(
    public val matchVariable: Output<String>,
    public val selector: Output<String>,
    public val selectorMatchOperator: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayFirewallExclusionArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayFirewallExclusionArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayFirewallExclusionArgs.builder()
            .matchVariable(matchVariable.applyValue({ args0 -> args0 }))
            .selector(selector.applyValue({ args0 -> args0 }))
            .selectorMatchOperator(selectorMatchOperator.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayFirewallExclusionArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayFirewallExclusionArgsBuilder internal constructor() {
    private var matchVariable: Output<String>? = null

    private var selector: Output<String>? = null

    private var selectorMatchOperator: Output<String>? = null

    /**
     * @param value The variable to be excluded.
     */
    @JvmName("tevyqiqkbuncflfd")
    public suspend fun matchVariable(`value`: Output<String>) {
        this.matchVariable = value
    }

    /**
     * @param value When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
     */
    @JvmName("leaxlrsjdochfcjq")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
     */
    @JvmName("awlqmpajdihojefs")
    public suspend fun selectorMatchOperator(`value`: Output<String>) {
        this.selectorMatchOperator = value
    }

    /**
     * @param value The variable to be excluded.
     */
    @JvmName("ueoppxtgsbfbjeva")
    public suspend fun matchVariable(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
     */
    @JvmName("cjxqtjhujkuytrlt")
    public suspend fun selector(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
     */
    @JvmName("lrxvegkikcexbrxk")
    public suspend fun selectorMatchOperator(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorMatchOperator = mapped
    }

    internal fun build(): ApplicationGatewayFirewallExclusionArgs =
        ApplicationGatewayFirewallExclusionArgs(
            matchVariable = matchVariable ?: throw PulumiNullFieldException("matchVariable"),
            selector = selector ?: throw PulumiNullFieldException("selector"),
            selectorMatchOperator = selectorMatchOperator ?: throw
                PulumiNullFieldException("selectorMatchOperator"),
        )
}
