@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayLoadDistributionPolicyArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayLoadDistributionAlgorithm
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Load Distribution Policy of an application gateway.
 * @property id Resource ID.
 * @property loadDistributionAlgorithm Load Distribution Targets resource of an application gateway.
 * @property loadDistributionTargets Load Distribution Targets resource of an application gateway.
 * @property name Name of the load distribution policy that is unique within an Application Gateway.
 */
public data class ApplicationGatewayLoadDistributionPolicyArgs(
    public val id: Output<String>? = null,
    public val loadDistributionAlgorithm:
    Output<Either<String, ApplicationGatewayLoadDistributionAlgorithm>>? = null,
    public val loadDistributionTargets: Output<List<ApplicationGatewayLoadDistributionTargetArgs>>? =
        null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayLoadDistributionPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayLoadDistributionPolicyArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayLoadDistributionPolicyArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .loadDistributionAlgorithm(
                loadDistributionAlgorithm?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .loadDistributionTargets(
                loadDistributionTargets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayLoadDistributionPolicyArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayLoadDistributionPolicyArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var loadDistributionAlgorithm:
        Output<Either<String, ApplicationGatewayLoadDistributionAlgorithm>>? = null

    private var loadDistributionTargets: Output<List<ApplicationGatewayLoadDistributionTargetArgs>>? =
        null

    private var name: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("cvmqqunkxqkmojts")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Load Distribution Targets resource of an application gateway.
     */
    @JvmName("wfsaotmsejvbtumk")
    public suspend
    fun loadDistributionAlgorithm(`value`: Output<Either<String, ApplicationGatewayLoadDistributionAlgorithm>>) {
        this.loadDistributionAlgorithm = value
    }

    /**
     * @param value Load Distribution Targets resource of an application gateway.
     */
    @JvmName("dnrubsxmnsalccax")
    public suspend
    fun loadDistributionTargets(`value`: Output<List<ApplicationGatewayLoadDistributionTargetArgs>>) {
        this.loadDistributionTargets = value
    }

    @JvmName("rymluodgsfihynew")
    public suspend fun loadDistributionTargets(
        vararg
        values: Output<ApplicationGatewayLoadDistributionTargetArgs>,
    ) {
        this.loadDistributionTargets = Output.all(values.asList())
    }

    /**
     * @param values Load Distribution Targets resource of an application gateway.
     */
    @JvmName("sehmrpsyyvrdvtih")
    public suspend
    fun loadDistributionTargets(values: List<Output<ApplicationGatewayLoadDistributionTargetArgs>>) {
        this.loadDistributionTargets = Output.all(values)
    }

    /**
     * @param value Name of the load distribution policy that is unique within an Application Gateway.
     */
    @JvmName("wxvgsyglnanclnxy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("eyyjstuamgseaqyy")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Load Distribution Targets resource of an application gateway.
     */
    @JvmName("ubhxgrncfnfoisjv")
    public suspend
    fun loadDistributionAlgorithm(`value`: Either<String, ApplicationGatewayLoadDistributionAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadDistributionAlgorithm = mapped
    }

    /**
     * @param value Load Distribution Targets resource of an application gateway.
     */
    @JvmName("tcldditftyqflvlo")
    public fun loadDistributionAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayLoadDistributionAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadDistributionAlgorithm = mapped
    }

    /**
     * @param value Load Distribution Targets resource of an application gateway.
     */
    @JvmName("xjeeagssuaxfwwka")
    public fun loadDistributionAlgorithm(`value`: ApplicationGatewayLoadDistributionAlgorithm) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayLoadDistributionAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadDistributionAlgorithm = mapped
    }

    /**
     * @param value Load Distribution Targets resource of an application gateway.
     */
    @JvmName("gagtaikntwupiugn")
    public suspend
    fun loadDistributionTargets(`value`: List<ApplicationGatewayLoadDistributionTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadDistributionTargets = mapped
    }

    /**
     * @param argument Load Distribution Targets resource of an application gateway.
     */
    @JvmName("uvwkrlrnsjrnpylw")
    public suspend
    fun loadDistributionTargets(argument: List<suspend ApplicationGatewayLoadDistributionTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayLoadDistributionTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.loadDistributionTargets = mapped
    }

    /**
     * @param argument Load Distribution Targets resource of an application gateway.
     */
    @JvmName("eyhyheaapooynaeo")
    public suspend fun loadDistributionTargets(
        vararg
        argument: suspend ApplicationGatewayLoadDistributionTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayLoadDistributionTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.loadDistributionTargets = mapped
    }

    /**
     * @param argument Load Distribution Targets resource of an application gateway.
     */
    @JvmName("gskolqlveixplmsd")
    public suspend
    fun loadDistributionTargets(argument: suspend ApplicationGatewayLoadDistributionTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayLoadDistributionTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadDistributionTargets = mapped
    }

    /**
     * @param values Load Distribution Targets resource of an application gateway.
     */
    @JvmName("anfpnupqhijwbtsx")
    public suspend fun loadDistributionTargets(
        vararg
        values: ApplicationGatewayLoadDistributionTargetArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadDistributionTargets = mapped
    }

    /**
     * @param value Name of the load distribution policy that is unique within an Application Gateway.
     */
    @JvmName("susykkapxnvaihtk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ApplicationGatewayLoadDistributionPolicyArgs =
        ApplicationGatewayLoadDistributionPolicyArgs(
            id = id,
            loadDistributionAlgorithm = loadDistributionAlgorithm,
            loadDistributionTargets = loadDistributionTargets,
            name = name,
        )
}
