@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayLoadDistributionTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Load Distribution Target of an application gateway.
 * @property backendAddressPool Backend address pool resource of the application gateway.
 * @property id Resource ID.
 * @property name Name of the load distribution policy that is unique within an Application Gateway.
 * @property weightPerServer Weight per server. Range between 1 and 100.
 */
public data class ApplicationGatewayLoadDistributionTargetArgs(
    public val backendAddressPool: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val weightPerServer: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayLoadDistributionTargetArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayLoadDistributionTargetArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayLoadDistributionTargetArgs.builder()
            .backendAddressPool(
                backendAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .weightPerServer(weightPerServer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayLoadDistributionTargetArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayLoadDistributionTargetArgsBuilder internal constructor() {
    private var backendAddressPool: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var weightPerServer: Output<Int>? = null

    /**
     * @param value Backend address pool resource of the application gateway.
     */
    @JvmName("cbfkrssvkyncwbks")
    public suspend fun backendAddressPool(`value`: Output<SubResourceArgs>) {
        this.backendAddressPool = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("nchhvyyanloqpkyr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the load distribution policy that is unique within an Application Gateway.
     */
    @JvmName("kyycogylifxioagl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Weight per server. Range between 1 and 100.
     */
    @JvmName("ttikhfxvyoybuqoa")
    public suspend fun weightPerServer(`value`: Output<Int>) {
        this.weightPerServer = value
    }

    /**
     * @param value Backend address pool resource of the application gateway.
     */
    @JvmName("kctnncwfyyunyrjy")
    public suspend fun backendAddressPool(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPool = mapped
    }

    /**
     * @param argument Backend address pool resource of the application gateway.
     */
    @JvmName("fpejjfkinmdydfay")
    public suspend fun backendAddressPool(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendAddressPool = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("njuhsokdtvbowsch")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the load distribution policy that is unique within an Application Gateway.
     */
    @JvmName("enngfuyiordufilk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Weight per server. Range between 1 and 100.
     */
    @JvmName("xoiqnhptmgiohiuc")
    public suspend fun weightPerServer(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightPerServer = mapped
    }

    internal fun build(): ApplicationGatewayLoadDistributionTargetArgs =
        ApplicationGatewayLoadDistributionTargetArgs(
            backendAddressPool = backendAddressPool,
            id = id,
            name = name,
            weightPerServer = weightPerServer,
        )
}
