@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayPrivateLinkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Private Link Configuration on an application gateway.
 * @property id Resource ID.
 * @property ipConfigurations An array of application gateway private link ip configurations.
 * @property name Name of the private link configuration that is unique within an Application Gateway.
 */
public data class ApplicationGatewayPrivateLinkConfigurationArgs(
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<ApplicationGatewayPrivateLinkIpConfigurationArgs>>? =
        null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayPrivateLinkConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayPrivateLinkConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayPrivateLinkConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayPrivateLinkConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayPrivateLinkConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<ApplicationGatewayPrivateLinkIpConfigurationArgs>>? =
        null

    private var name: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("yeelxayfswyooyls")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value An array of application gateway private link ip configurations.
     */
    @JvmName("oyfmptbvhgyvkbre")
    public suspend
    fun ipConfigurations(`value`: Output<List<ApplicationGatewayPrivateLinkIpConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("chdsbxgatsuvypeb")
    public suspend fun ipConfigurations(
        vararg
        values: Output<ApplicationGatewayPrivateLinkIpConfigurationArgs>,
    ) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values An array of application gateway private link ip configurations.
     */
    @JvmName("iwhlnttnlrfeweav")
    public suspend
    fun ipConfigurations(values: List<Output<ApplicationGatewayPrivateLinkIpConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value Name of the private link configuration that is unique within an Application Gateway.
     */
    @JvmName("ihilhathsideithi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ggdthhrbdvrxxeuq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value An array of application gateway private link ip configurations.
     */
    @JvmName("srtdtwqsxsqvgomx")
    public suspend
    fun ipConfigurations(`value`: List<ApplicationGatewayPrivateLinkIpConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of application gateway private link ip configurations.
     */
    @JvmName("fkccxgtvwfsqnpqe")
    public suspend
    fun ipConfigurations(argument: List<suspend ApplicationGatewayPrivateLinkIpConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayPrivateLinkIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of application gateway private link ip configurations.
     */
    @JvmName("mlnjicfobjnikqnm")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend ApplicationGatewayPrivateLinkIpConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayPrivateLinkIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of application gateway private link ip configurations.
     */
    @JvmName("nngrgwbascmsetbt")
    public suspend
    fun ipConfigurations(argument: suspend ApplicationGatewayPrivateLinkIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayPrivateLinkIpConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values An array of application gateway private link ip configurations.
     */
    @JvmName("elulxubiwiadpvxn")
    public suspend fun ipConfigurations(
        vararg
        values: ApplicationGatewayPrivateLinkIpConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value Name of the private link configuration that is unique within an Application Gateway.
     */
    @JvmName("nkjxijuevprlyffv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ApplicationGatewayPrivateLinkConfigurationArgs =
        ApplicationGatewayPrivateLinkConfigurationArgs(
            id = id,
            ipConfigurations = ipConfigurations,
            name = name,
        )
}
