@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeHealthResponseMatch.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Application gateway probe health response match.
 * @property body Body that must be contained in the health response. Default value is empty.
 * @property statusCodes Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
 */
public data class ApplicationGatewayProbeHealthResponseMatch(
    public val body: String? = null,
    public val statusCodes: List<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeHealthResponseMatch> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeHealthResponseMatch =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeHealthResponseMatch.builder()
            .body(body?.let({ args0 -> args0 }))
            .statusCodes(statusCodes?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApplicationGatewayProbeHealthResponseMatch].
 */
@PulumiTagMarker
public class ApplicationGatewayProbeHealthResponseMatchBuilder internal constructor() {
    private var body: String? = null

    private var statusCodes: List<String>? = null

    /**
     * @param value Body that must be contained in the health response. Default value is empty.
     */
    @JvmName("fsrwnworkichclch")
    public suspend fun body(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.body = mapped
    }

    /**
     * @param value Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
     */
    @JvmName("vankkqgpuxclxgii")
    public suspend fun statusCodes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.statusCodes = mapped
    }

    /**
     * @param values Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
     */
    @JvmName("farxtqikrgyklxku")
    public suspend fun statusCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.statusCodes = mapped
    }

    internal fun build(): ApplicationGatewayProbeHealthResponseMatch =
        ApplicationGatewayProbeHealthResponseMatch(
            body = body,
            statusCodes = statusCodes,
        )
}
