@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewaySslPolicyArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewaySslCipherSuite
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewaySslPolicyName
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewaySslPolicyType
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewaySslProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Application Gateway Ssl policy.
 * @property cipherSuites Ssl cipher suites to be enabled in the specified order to application gateway.
 * @property disabledSslProtocols Ssl protocols to be disabled on application gateway.
 * @property minProtocolVersion Minimum version of Ssl protocol to be supported on application gateway.
 * @property policyName Name of Ssl predefined policy.
 * @property policyType Type of Ssl Policy.
 */
public data class ApplicationGatewaySslPolicyArgs(
    public val cipherSuites: Output<List<Either<String, ApplicationGatewaySslCipherSuite>>>? = null,
    public val disabledSslProtocols: Output<List<Either<String, ApplicationGatewaySslProtocol>>>? =
        null,
    public val minProtocolVersion: Output<Either<String, ApplicationGatewaySslProtocol>>? = null,
    public val policyName: Output<Either<String, ApplicationGatewaySslPolicyName>>? = null,
    public val policyType: Output<Either<String, ApplicationGatewaySslPolicyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewaySslPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewaySslPolicyArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewaySslPolicyArgs.builder()
            .cipherSuites(
                cipherSuites?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .disabledSslProtocols(
                disabledSslProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .minProtocolVersion(
                minProtocolVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policyName(
                policyName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewaySslPolicyArgs].
 */
@PulumiTagMarker
public class ApplicationGatewaySslPolicyArgsBuilder internal constructor() {
    private var cipherSuites: Output<List<Either<String, ApplicationGatewaySslCipherSuite>>>? = null

    private var disabledSslProtocols: Output<List<Either<String, ApplicationGatewaySslProtocol>>>? =
        null

    private var minProtocolVersion: Output<Either<String, ApplicationGatewaySslProtocol>>? = null

    private var policyName: Output<Either<String, ApplicationGatewaySslPolicyName>>? = null

    private var policyType: Output<Either<String, ApplicationGatewaySslPolicyType>>? = null

    /**
     * @param value Ssl cipher suites to be enabled in the specified order to application gateway.
     */
    @JvmName("xkxiknrfmmndxlaa")
    public suspend
    fun cipherSuites(`value`: Output<List<Either<String, ApplicationGatewaySslCipherSuite>>>) {
        this.cipherSuites = value
    }

    @JvmName("bbktpnbxxprqsspb")
    public suspend fun cipherSuites(
        vararg
        values: Output<Either<String, ApplicationGatewaySslCipherSuite>>,
    ) {
        this.cipherSuites = Output.all(values.asList())
    }

    /**
     * @param values Ssl cipher suites to be enabled in the specified order to application gateway.
     */
    @JvmName("ckaokpvpdqpvxlgb")
    public suspend
    fun cipherSuites(values: List<Output<Either<String, ApplicationGatewaySslCipherSuite>>>) {
        this.cipherSuites = Output.all(values)
    }

    /**
     * @param value Ssl protocols to be disabled on application gateway.
     */
    @JvmName("sluswrfptxuaioqb")
    public suspend
    fun disabledSslProtocols(`value`: Output<List<Either<String, ApplicationGatewaySslProtocol>>>) {
        this.disabledSslProtocols = value
    }

    @JvmName("yctrtpajverelife")
    public suspend fun disabledSslProtocols(
        vararg
        values: Output<Either<String, ApplicationGatewaySslProtocol>>,
    ) {
        this.disabledSslProtocols = Output.all(values.asList())
    }

    /**
     * @param values Ssl protocols to be disabled on application gateway.
     */
    @JvmName("mifrcvswwlfxwisk")
    public suspend
    fun disabledSslProtocols(values: List<Output<Either<String, ApplicationGatewaySslProtocol>>>) {
        this.disabledSslProtocols = Output.all(values)
    }

    /**
     * @param value Minimum version of Ssl protocol to be supported on application gateway.
     */
    @JvmName("rmxhjcrnsitefqsd")
    public suspend
    fun minProtocolVersion(`value`: Output<Either<String, ApplicationGatewaySslProtocol>>) {
        this.minProtocolVersion = value
    }

    /**
     * @param value Name of Ssl predefined policy.
     */
    @JvmName("cuhggbfeethsrkdj")
    public suspend fun policyName(`value`: Output<Either<String, ApplicationGatewaySslPolicyName>>) {
        this.policyName = value
    }

    /**
     * @param value Type of Ssl Policy.
     */
    @JvmName("krvxhywjhmmnqqmb")
    public suspend fun policyType(`value`: Output<Either<String, ApplicationGatewaySslPolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value Ssl cipher suites to be enabled in the specified order to application gateway.
     */
    @JvmName("stnliffncmftcnrk")
    public suspend
    fun cipherSuites(`value`: List<Either<String, ApplicationGatewaySslCipherSuite>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cipherSuites = mapped
    }

    /**
     * @param values Ssl cipher suites to be enabled in the specified order to application gateway.
     */
    @JvmName("yfblbdwfongekfbq")
    public suspend fun cipherSuites(vararg values: Either<String, ApplicationGatewaySslCipherSuite>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cipherSuites = mapped
    }

    /**
     * @param value Ssl protocols to be disabled on application gateway.
     */
    @JvmName("mbsqrvwmhbusoelv")
    public suspend
    fun disabledSslProtocols(`value`: List<Either<String, ApplicationGatewaySslProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabledSslProtocols = mapped
    }

    /**
     * @param values Ssl protocols to be disabled on application gateway.
     */
    @JvmName("hnvyhywufwwidsjj")
    public suspend fun disabledSslProtocols(
        vararg
        values: Either<String, ApplicationGatewaySslProtocol>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disabledSslProtocols = mapped
    }

    /**
     * @param value Minimum version of Ssl protocol to be supported on application gateway.
     */
    @JvmName("fdaavbqmjqjyuenk")
    public suspend fun minProtocolVersion(`value`: Either<String, ApplicationGatewaySslProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minProtocolVersion = mapped
    }

    /**
     * @param value Minimum version of Ssl protocol to be supported on application gateway.
     */
    @JvmName("fdpbsurhatovjhes")
    public fun minProtocolVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewaySslProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minProtocolVersion = mapped
    }

    /**
     * @param value Minimum version of Ssl protocol to be supported on application gateway.
     */
    @JvmName("fvdyabkxjakiqktl")
    public fun minProtocolVersion(`value`: ApplicationGatewaySslProtocol) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewaySslProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minProtocolVersion = mapped
    }

    /**
     * @param value Name of Ssl predefined policy.
     */
    @JvmName("qrphjrcgljykusfp")
    public suspend fun policyName(`value`: Either<String, ApplicationGatewaySslPolicyName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Name of Ssl predefined policy.
     */
    @JvmName("odanjenjaipqajqm")
    public fun policyName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewaySslPolicyName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Name of Ssl predefined policy.
     */
    @JvmName("vprgucwkctocmucv")
    public fun policyName(`value`: ApplicationGatewaySslPolicyName) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewaySslPolicyName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Type of Ssl Policy.
     */
    @JvmName("nrsdmuygyrbvfkxx")
    public suspend fun policyType(`value`: Either<String, ApplicationGatewaySslPolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Type of Ssl Policy.
     */
    @JvmName("aoqavfsnsgtpvcaa")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewaySslPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Type of Ssl Policy.
     */
    @JvmName("lgbomkwonccehjwv")
    public fun policyType(`value`: ApplicationGatewaySslPolicyType) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewaySslPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    internal fun build(): ApplicationGatewaySslPolicyArgs = ApplicationGatewaySslPolicyArgs(
        cipherSuites = cipherSuites,
        disabledSslProtocols = disabledSslProtocols,
        minProtocolVersion = minProtocolVersion,
        policyName = policyName,
        policyType = policyType,
    )
}
