@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayWebApplicationFirewallConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayFirewallMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Application gateway web application firewall configuration.
 * @property disabledRuleGroups The disabled rule groups.
 * @property enabled Whether the web application firewall is enabled or not.
 * @property exclusions The exclusion list.
 * @property fileUploadLimitInMb Maximum file upload size in Mb for WAF.
 * @property firewallMode Web application firewall mode.
 * @property maxRequestBodySize Maximum request body size for WAF.
 * @property maxRequestBodySizeInKb Maximum request body size in Kb for WAF.
 * @property requestBodyCheck Whether allow WAF to check request Body.
 * @property ruleSetType The type of the web application firewall rule set. Possible values are: 'OWASP'.
 * @property ruleSetVersion The version of the rule set type.
 */
public data class ApplicationGatewayWebApplicationFirewallConfigurationArgs(
    public val disabledRuleGroups: Output<List<ApplicationGatewayFirewallDisabledRuleGroupArgs>>? =
        null,
    public val enabled: Output<Boolean>,
    public val exclusions: Output<List<ApplicationGatewayFirewallExclusionArgs>>? = null,
    public val fileUploadLimitInMb: Output<Int>? = null,
    public val firewallMode: Output<Either<String, ApplicationGatewayFirewallMode>>,
    public val maxRequestBodySize: Output<Int>? = null,
    public val maxRequestBodySizeInKb: Output<Int>? = null,
    public val requestBodyCheck: Output<Boolean>? = null,
    public val ruleSetType: Output<String>,
    public val ruleSetVersion: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayWebApplicationFirewallConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayWebApplicationFirewallConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayWebApplicationFirewallConfigurationArgs.builder()
            .disabledRuleGroups(
                disabledRuleGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .exclusions(
                exclusions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .fileUploadLimitInMb(fileUploadLimitInMb?.applyValue({ args0 -> args0 }))
            .firewallMode(
                firewallMode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .maxRequestBodySize(maxRequestBodySize?.applyValue({ args0 -> args0 }))
            .maxRequestBodySizeInKb(maxRequestBodySizeInKb?.applyValue({ args0 -> args0 }))
            .requestBodyCheck(requestBodyCheck?.applyValue({ args0 -> args0 }))
            .ruleSetType(ruleSetType.applyValue({ args0 -> args0 }))
            .ruleSetVersion(ruleSetVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayWebApplicationFirewallConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayWebApplicationFirewallConfigurationArgsBuilder internal constructor() {
    private var disabledRuleGroups: Output<List<ApplicationGatewayFirewallDisabledRuleGroupArgs>>? =
        null

    private var enabled: Output<Boolean>? = null

    private var exclusions: Output<List<ApplicationGatewayFirewallExclusionArgs>>? = null

    private var fileUploadLimitInMb: Output<Int>? = null

    private var firewallMode: Output<Either<String, ApplicationGatewayFirewallMode>>? = null

    private var maxRequestBodySize: Output<Int>? = null

    private var maxRequestBodySizeInKb: Output<Int>? = null

    private var requestBodyCheck: Output<Boolean>? = null

    private var ruleSetType: Output<String>? = null

    private var ruleSetVersion: Output<String>? = null

    /**
     * @param value The disabled rule groups.
     */
    @JvmName("nrsuesgqoaxpvbya")
    public suspend
    fun disabledRuleGroups(`value`: Output<List<ApplicationGatewayFirewallDisabledRuleGroupArgs>>) {
        this.disabledRuleGroups = value
    }

    @JvmName("uudrvpswhrkeicvm")
    public suspend fun disabledRuleGroups(
        vararg
        values: Output<ApplicationGatewayFirewallDisabledRuleGroupArgs>,
    ) {
        this.disabledRuleGroups = Output.all(values.asList())
    }

    /**
     * @param values The disabled rule groups.
     */
    @JvmName("thxwrgjsprspfuqx")
    public suspend
    fun disabledRuleGroups(values: List<Output<ApplicationGatewayFirewallDisabledRuleGroupArgs>>) {
        this.disabledRuleGroups = Output.all(values)
    }

    /**
     * @param value Whether the web application firewall is enabled or not.
     */
    @JvmName("uxlqxhoqsiaeecfp")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The exclusion list.
     */
    @JvmName("pfpphdeeeoaffvxf")
    public suspend fun exclusions(`value`: Output<List<ApplicationGatewayFirewallExclusionArgs>>) {
        this.exclusions = value
    }

    @JvmName("bgnvkoyxpfbeeusk")
    public suspend fun exclusions(vararg values: Output<ApplicationGatewayFirewallExclusionArgs>) {
        this.exclusions = Output.all(values.asList())
    }

    /**
     * @param values The exclusion list.
     */
    @JvmName("ysoohvlblqxkmmqr")
    public suspend fun exclusions(values: List<Output<ApplicationGatewayFirewallExclusionArgs>>) {
        this.exclusions = Output.all(values)
    }

    /**
     * @param value Maximum file upload size in Mb for WAF.
     */
    @JvmName("wrxvsfoducmbotqq")
    public suspend fun fileUploadLimitInMb(`value`: Output<Int>) {
        this.fileUploadLimitInMb = value
    }

    /**
     * @param value Web application firewall mode.
     */
    @JvmName("nbckvbpvptvracua")
    public suspend fun firewallMode(`value`: Output<Either<String, ApplicationGatewayFirewallMode>>) {
        this.firewallMode = value
    }

    /**
     * @param value Maximum request body size for WAF.
     */
    @JvmName("cxqcitcidoosqaox")
    public suspend fun maxRequestBodySize(`value`: Output<Int>) {
        this.maxRequestBodySize = value
    }

    /**
     * @param value Maximum request body size in Kb for WAF.
     */
    @JvmName("grqeqpeajvaidyka")
    public suspend fun maxRequestBodySizeInKb(`value`: Output<Int>) {
        this.maxRequestBodySizeInKb = value
    }

    /**
     * @param value Whether allow WAF to check request Body.
     */
    @JvmName("jnncdxsatmvxvjbs")
    public suspend fun requestBodyCheck(`value`: Output<Boolean>) {
        this.requestBodyCheck = value
    }

    /**
     * @param value The type of the web application firewall rule set. Possible values are: 'OWASP'.
     */
    @JvmName("xfqvtoafasleitcm")
    public suspend fun ruleSetType(`value`: Output<String>) {
        this.ruleSetType = value
    }

    /**
     * @param value The version of the rule set type.
     */
    @JvmName("twjpkokcylbnccoq")
    public suspend fun ruleSetVersion(`value`: Output<String>) {
        this.ruleSetVersion = value
    }

    /**
     * @param value The disabled rule groups.
     */
    @JvmName("vassjlgiepaetjyc")
    public suspend
    fun disabledRuleGroups(`value`: List<ApplicationGatewayFirewallDisabledRuleGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabledRuleGroups = mapped
    }

    /**
     * @param argument The disabled rule groups.
     */
    @JvmName("auxbamhymajolefb")
    public suspend
    fun disabledRuleGroups(argument: List<suspend ApplicationGatewayFirewallDisabledRuleGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayFirewallDisabledRuleGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.disabledRuleGroups = mapped
    }

    /**
     * @param argument The disabled rule groups.
     */
    @JvmName("lqhrrpplvajedapx")
    public suspend fun disabledRuleGroups(
        vararg
        argument: suspend ApplicationGatewayFirewallDisabledRuleGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayFirewallDisabledRuleGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.disabledRuleGroups = mapped
    }

    /**
     * @param argument The disabled rule groups.
     */
    @JvmName("evtnmstbvhdsewmj")
    public suspend
    fun disabledRuleGroups(argument: suspend ApplicationGatewayFirewallDisabledRuleGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayFirewallDisabledRuleGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.disabledRuleGroups = mapped
    }

    /**
     * @param values The disabled rule groups.
     */
    @JvmName("aixatvyjwvrrlkyt")
    public suspend fun disabledRuleGroups(
        vararg
        values: ApplicationGatewayFirewallDisabledRuleGroupArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disabledRuleGroups = mapped
    }

    /**
     * @param value Whether the web application firewall is enabled or not.
     */
    @JvmName("gexrupjtbjasxxyx")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The exclusion list.
     */
    @JvmName("ipqtmkujxuypmswe")
    public suspend fun exclusions(`value`: List<ApplicationGatewayFirewallExclusionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param argument The exclusion list.
     */
    @JvmName("sexdlkilggayoudx")
    public suspend
    fun exclusions(argument: List<suspend ApplicationGatewayFirewallExclusionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayFirewallExclusionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument The exclusion list.
     */
    @JvmName("eqpcfrkktjbnfogs")
    public suspend fun exclusions(
        vararg
        argument: suspend ApplicationGatewayFirewallExclusionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayFirewallExclusionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument The exclusion list.
     */
    @JvmName("qjctkvcjjlspqhgh")
    public suspend
    fun exclusions(argument: suspend ApplicationGatewayFirewallExclusionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayFirewallExclusionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param values The exclusion list.
     */
    @JvmName("usewypjrdiwdeetc")
    public suspend fun exclusions(vararg values: ApplicationGatewayFirewallExclusionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param value Maximum file upload size in Mb for WAF.
     */
    @JvmName("ubqsnsvadxrtfdrv")
    public suspend fun fileUploadLimitInMb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileUploadLimitInMb = mapped
    }

    /**
     * @param value Web application firewall mode.
     */
    @JvmName("cvdfbrrdjpcatpmo")
    public suspend fun firewallMode(`value`: Either<String, ApplicationGatewayFirewallMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firewallMode = mapped
    }

    /**
     * @param value Web application firewall mode.
     */
    @JvmName("ldhphruupvuactjd")
    public fun firewallMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayFirewallMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firewallMode = mapped
    }

    /**
     * @param value Web application firewall mode.
     */
    @JvmName("fvrlvpuyqpxtrukw")
    public fun firewallMode(`value`: ApplicationGatewayFirewallMode) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayFirewallMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firewallMode = mapped
    }

    /**
     * @param value Maximum request body size for WAF.
     */
    @JvmName("gdetlptijjtkuuna")
    public suspend fun maxRequestBodySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRequestBodySize = mapped
    }

    /**
     * @param value Maximum request body size in Kb for WAF.
     */
    @JvmName("mtlamsftoqkkiaxi")
    public suspend fun maxRequestBodySizeInKb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRequestBodySizeInKb = mapped
    }

    /**
     * @param value Whether allow WAF to check request Body.
     */
    @JvmName("vghykktbvrpjdlkv")
    public suspend fun requestBodyCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBodyCheck = mapped
    }

    /**
     * @param value The type of the web application firewall rule set. Possible values are: 'OWASP'.
     */
    @JvmName("ehfbwintkxjbwkjd")
    public suspend fun ruleSetType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetType = mapped
    }

    /**
     * @param value The version of the rule set type.
     */
    @JvmName("ksfnwvejthrembwy")
    public suspend fun ruleSetVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetVersion = mapped
    }

    internal fun build(): ApplicationGatewayWebApplicationFirewallConfigurationArgs =
        ApplicationGatewayWebApplicationFirewallConfigurationArgs(
            disabledRuleGroups = disabledRuleGroups,
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            exclusions = exclusions,
            fileUploadLimitInMb = fileUploadLimitInMb,
            firewallMode = firewallMode ?: throw PulumiNullFieldException("firewallMode"),
            maxRequestBodySize = maxRequestBodySize,
            maxRequestBodySizeInKb = maxRequestBodySizeInKb,
            requestBodyCheck = requestBodyCheck,
            ruleSetType = ruleSetType ?: throw PulumiNullFieldException("ruleSetType"),
            ruleSetVersion = ruleSetVersion ?: throw PulumiNullFieldException("ruleSetVersion"),
        )
}
