@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule of type application.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property fqdnTags List of FQDN Tags for this rule.
 * @property httpHeadersToInsert List of HTTP/S headers to insert.
 * @property name Name of the rule.
 * @property protocols Array of Application Protocols.
 * @property ruleType Rule Type.
 * Expected value is 'ApplicationRule'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property targetFqdns List of FQDNs for this rule.
 * @property targetUrls List of Urls for this rule condition.
 * @property terminateTLS Terminate TLS connections for this rule.
 * @property webCategories List of destination azure web categories.
 */
public data class ApplicationRuleArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val fqdnTags: Output<List<String>>? = null,
    public val httpHeadersToInsert: Output<List<FirewallPolicyHttpHeaderToInsertArgs>>? = null,
    public val name: Output<String>? = null,
    public val protocols: Output<List<FirewallPolicyRuleApplicationProtocolArgs>>? = null,
    public val ruleType: Output<String>,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
    public val targetFqdns: Output<List<String>>? = null,
    public val targetUrls: Output<List<String>>? = null,
    public val terminateTLS: Output<Boolean>? = null,
    public val webCategories: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationRuleArgs =
        com.pulumi.azurenative.network.inputs.ApplicationRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .fqdnTags(fqdnTags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .httpHeadersToInsert(
                httpHeadersToInsert?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .protocols(
                protocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleType(ruleType.applyValue({ args0 -> args0 }))
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetFqdns(targetFqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetUrls(targetUrls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .terminateTLS(terminateTLS?.applyValue({ args0 -> args0 }))
            .webCategories(webCategories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApplicationRuleArgs].
 */
@PulumiTagMarker
public class ApplicationRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var fqdnTags: Output<List<String>>? = null

    private var httpHeadersToInsert: Output<List<FirewallPolicyHttpHeaderToInsertArgs>>? = null

    private var name: Output<String>? = null

    private var protocols: Output<List<FirewallPolicyRuleApplicationProtocolArgs>>? = null

    private var ruleType: Output<String>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    private var targetFqdns: Output<List<String>>? = null

    private var targetUrls: Output<List<String>>? = null

    private var terminateTLS: Output<Boolean>? = null

    private var webCategories: Output<List<String>>? = null

    /**
     * @param value Description of the rule.
     */
    @JvmName("admllxpjvelsqegb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("huyojrtwjcponumq")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("wvfbtbutpabhglpr")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("psxfyntuwtpkoxnk")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of FQDN Tags for this rule.
     */
    @JvmName("rmexvtoowwrpsgyf")
    public suspend fun fqdnTags(`value`: Output<List<String>>) {
        this.fqdnTags = value
    }

    @JvmName("hdgwigymifvbdfok")
    public suspend fun fqdnTags(vararg values: Output<String>) {
        this.fqdnTags = Output.all(values.asList())
    }

    /**
     * @param values List of FQDN Tags for this rule.
     */
    @JvmName("cviovfthvmnwstxt")
    public suspend fun fqdnTags(values: List<Output<String>>) {
        this.fqdnTags = Output.all(values)
    }

    /**
     * @param value List of HTTP/S headers to insert.
     */
    @JvmName("dshqldaeudwnhpyj")
    public suspend
    fun httpHeadersToInsert(`value`: Output<List<FirewallPolicyHttpHeaderToInsertArgs>>) {
        this.httpHeadersToInsert = value
    }

    @JvmName("svkooxloevsrijns")
    public suspend fun httpHeadersToInsert(
        vararg
        values: Output<FirewallPolicyHttpHeaderToInsertArgs>,
    ) {
        this.httpHeadersToInsert = Output.all(values.asList())
    }

    /**
     * @param values List of HTTP/S headers to insert.
     */
    @JvmName("jhcetiannvhdkavc")
    public suspend
    fun httpHeadersToInsert(values: List<Output<FirewallPolicyHttpHeaderToInsertArgs>>) {
        this.httpHeadersToInsert = Output.all(values)
    }

    /**
     * @param value Name of the rule.
     */
    @JvmName("nqflakaxqsdthxuj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Array of Application Protocols.
     */
    @JvmName("xitapvfgvhsduoas")
    public suspend fun protocols(`value`: Output<List<FirewallPolicyRuleApplicationProtocolArgs>>) {
        this.protocols = value
    }

    @JvmName("nfmwjhcyvwdstkkw")
    public suspend fun protocols(vararg values: Output<FirewallPolicyRuleApplicationProtocolArgs>) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values Array of Application Protocols.
     */
    @JvmName("lwhqqqbklpxhoaub")
    public suspend fun protocols(values: List<Output<FirewallPolicyRuleApplicationProtocolArgs>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value Rule Type.
     * Expected value is 'ApplicationRule'.
     */
    @JvmName("cbssgbrlqsdwfhce")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("qdeekbvppsqxnmyh")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("kidgmobutxaghrci")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("oblheobaxmstanxj")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("mrbrdsjhccskares")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("qtssruyfsreoyafa")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("eysbjhmgjhyfnqen")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value List of FQDNs for this rule.
     */
    @JvmName("pbxargecxwbsqbwt")
    public suspend fun targetFqdns(`value`: Output<List<String>>) {
        this.targetFqdns = value
    }

    @JvmName("oioeuwxdcywkqaoc")
    public suspend fun targetFqdns(vararg values: Output<String>) {
        this.targetFqdns = Output.all(values.asList())
    }

    /**
     * @param values List of FQDNs for this rule.
     */
    @JvmName("fdiibjejlqeiabxd")
    public suspend fun targetFqdns(values: List<Output<String>>) {
        this.targetFqdns = Output.all(values)
    }

    /**
     * @param value List of Urls for this rule condition.
     */
    @JvmName("bdtmdtqpgehcfloq")
    public suspend fun targetUrls(`value`: Output<List<String>>) {
        this.targetUrls = value
    }

    @JvmName("oovubokkmncggrcr")
    public suspend fun targetUrls(vararg values: Output<String>) {
        this.targetUrls = Output.all(values.asList())
    }

    /**
     * @param values List of Urls for this rule condition.
     */
    @JvmName("tdslsiwdfmyqmfvl")
    public suspend fun targetUrls(values: List<Output<String>>) {
        this.targetUrls = Output.all(values)
    }

    /**
     * @param value Terminate TLS connections for this rule.
     */
    @JvmName("xhdxqgfrehlbjnkx")
    public suspend fun terminateTLS(`value`: Output<Boolean>) {
        this.terminateTLS = value
    }

    /**
     * @param value List of destination azure web categories.
     */
    @JvmName("fbjhlrwcbfmpfahg")
    public suspend fun webCategories(`value`: Output<List<String>>) {
        this.webCategories = value
    }

    @JvmName("ksmxiaughmesybkb")
    public suspend fun webCategories(vararg values: Output<String>) {
        this.webCategories = Output.all(values.asList())
    }

    /**
     * @param values List of destination azure web categories.
     */
    @JvmName("iqtjhbdlbuttbcis")
    public suspend fun webCategories(values: List<Output<String>>) {
        this.webCategories = Output.all(values)
    }

    /**
     * @param value Description of the rule.
     */
    @JvmName("lhskygdfqgvmnyry")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("vfiapbgljyrycfbi")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("dkvomffifdlpvtuo")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of FQDN Tags for this rule.
     */
    @JvmName("jsklatwtqooshuxc")
    public suspend fun fqdnTags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnTags = mapped
    }

    /**
     * @param values List of FQDN Tags for this rule.
     */
    @JvmName("tauwtpjobjcqawxw")
    public suspend fun fqdnTags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdnTags = mapped
    }

    /**
     * @param value List of HTTP/S headers to insert.
     */
    @JvmName("isyqgasujatwckeu")
    public suspend fun httpHeadersToInsert(`value`: List<FirewallPolicyHttpHeaderToInsertArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpHeadersToInsert = mapped
    }

    /**
     * @param argument List of HTTP/S headers to insert.
     */
    @JvmName("snjgnayfvkpnbjna")
    public suspend
    fun httpHeadersToInsert(argument: List<suspend FirewallPolicyHttpHeaderToInsertArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyHttpHeaderToInsertArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeadersToInsert = mapped
    }

    /**
     * @param argument List of HTTP/S headers to insert.
     */
    @JvmName("otierqmufbrfqfwi")
    public suspend fun httpHeadersToInsert(
        vararg
        argument: suspend FirewallPolicyHttpHeaderToInsertArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyHttpHeaderToInsertArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeadersToInsert = mapped
    }

    /**
     * @param argument List of HTTP/S headers to insert.
     */
    @JvmName("qclbpqpkhekomidj")
    public suspend
    fun httpHeadersToInsert(argument: suspend FirewallPolicyHttpHeaderToInsertArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FirewallPolicyHttpHeaderToInsertArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpHeadersToInsert = mapped
    }

    /**
     * @param values List of HTTP/S headers to insert.
     */
    @JvmName("foeqqybxvtoshhky")
    public suspend fun httpHeadersToInsert(vararg values: FirewallPolicyHttpHeaderToInsertArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpHeadersToInsert = mapped
    }

    /**
     * @param value Name of the rule.
     */
    @JvmName("brfuciawvijnydsw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Array of Application Protocols.
     */
    @JvmName("dacywaghrypmrwnh")
    public suspend fun protocols(`value`: List<FirewallPolicyRuleApplicationProtocolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param argument Array of Application Protocols.
     */
    @JvmName("gqjjrumbrfersrtf")
    public suspend
    fun protocols(argument: List<suspend FirewallPolicyRuleApplicationProtocolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyRuleApplicationProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param argument Array of Application Protocols.
     */
    @JvmName("exucpdppjljxifoj")
    public suspend fun protocols(
        vararg
        argument: suspend FirewallPolicyRuleApplicationProtocolArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyRuleApplicationProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param argument Array of Application Protocols.
     */
    @JvmName("nimbulttlsjnkfob")
    public suspend
    fun protocols(argument: suspend FirewallPolicyRuleApplicationProtocolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FirewallPolicyRuleApplicationProtocolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param values Array of Application Protocols.
     */
    @JvmName("vjnhgxpepjjdwiye")
    public suspend fun protocols(vararg values: FirewallPolicyRuleApplicationProtocolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value Rule Type.
     * Expected value is 'ApplicationRule'.
     */
    @JvmName("kippugbbytvmatym")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("ymehxkjrqgcdsehw")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("nvehmillnvawdfnk")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("obfnrajfkjbnewpo")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("brtlvpjltgntbqsp")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param value List of FQDNs for this rule.
     */
    @JvmName("efsjvpfkxhvpwbwn")
    public suspend fun targetFqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetFqdns = mapped
    }

    /**
     * @param values List of FQDNs for this rule.
     */
    @JvmName("ykbynhdatkbixpsa")
    public suspend fun targetFqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetFqdns = mapped
    }

    /**
     * @param value List of Urls for this rule condition.
     */
    @JvmName("rtbocglwbugmbvge")
    public suspend fun targetUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetUrls = mapped
    }

    /**
     * @param values List of Urls for this rule condition.
     */
    @JvmName("kvbkbnrsopacadgx")
    public suspend fun targetUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetUrls = mapped
    }

    /**
     * @param value Terminate TLS connections for this rule.
     */
    @JvmName("vxonyyvnrgxcfcih")
    public suspend fun terminateTLS(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateTLS = mapped
    }

    /**
     * @param value List of destination azure web categories.
     */
    @JvmName("grkgqrdycjytciqt")
    public suspend fun webCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webCategories = mapped
    }

    /**
     * @param values List of destination azure web categories.
     */
    @JvmName("exycsnwsbvexdond")
    public suspend fun webCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webCategories = mapped
    }

    internal fun build(): ApplicationRuleArgs = ApplicationRuleArgs(
        description = description,
        destinationAddresses = destinationAddresses,
        fqdnTags = fqdnTags,
        httpHeadersToInsert = httpHeadersToInsert,
        name = name,
        protocols = protocols,
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
        sourceAddresses = sourceAddresses,
        sourceIpGroups = sourceIpGroups,
        targetFqdns = targetFqdns,
        targetUrls = targetUrls,
        terminateTLS = terminateTLS,
        webCategories = webCategories,
    )
}
