@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationSecurityGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An application security group in a resource group.
 * @property id Resource ID.
 * @property location Resource location.
 * @property tags Resource tags.
 */
public data class ApplicationSecurityGroupArgs(
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationSecurityGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationSecurityGroupArgs =
        com.pulumi.azurenative.network.inputs.ApplicationSecurityGroupArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationSecurityGroupArgs].
 */
@PulumiTagMarker
public class ApplicationSecurityGroupArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("qtihqwfdyrbrxcya")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("pwxmagkqejelhdjb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wgfvenrmvcammxjf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("fnpydyoefytshlbo")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("eurwccqrirqoeang")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gfmvqnyuvfxynuto")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ubtysriogosivrhp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationSecurityGroupArgs = ApplicationSecurityGroupArgs(
        id = id,
        location = location,
        tags = tags,
    )
}
