@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallNatRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AzureFirewallNetworkRuleProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a NAT rule.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
 * @property destinationPorts List of destination ports.
 * @property name Name of the NAT rule.
 * @property protocols Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property translatedAddress The translated address for this NAT rule.
 * @property translatedFqdn The translated FQDN for this NAT rule.
 * @property translatedPort The translated port for this NAT rule.
 */
public data class AzureFirewallNatRuleArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val destinationPorts: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val protocols: Output<List<Either<String, AzureFirewallNetworkRuleProtocol>>>? = null,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
    public val translatedAddress: Output<String>? = null,
    public val translatedFqdn: Output<String>? = null,
    public val translatedPort: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallNatRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AzureFirewallNatRuleArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallNatRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationPorts(destinationPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocols(
                protocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .translatedAddress(translatedAddress?.applyValue({ args0 -> args0 }))
            .translatedFqdn(translatedFqdn?.applyValue({ args0 -> args0 }))
            .translatedPort(translatedPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFirewallNatRuleArgs].
 */
@PulumiTagMarker
public class AzureFirewallNatRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var destinationPorts: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var protocols: Output<List<Either<String, AzureFirewallNetworkRuleProtocol>>>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    private var translatedAddress: Output<String>? = null

    private var translatedFqdn: Output<String>? = null

    private var translatedPort: Output<String>? = null

    /**
     * @param value Description of the rule.
     */
    @JvmName("xkjlfotjeytasyge")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
     */
    @JvmName("bvwgpbimwlrwuogh")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("avysfsjhqvwvaqph")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
     */
    @JvmName("jpwduiibksktdrve")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("nyrfvygofiorihst")
    public suspend fun destinationPorts(`value`: Output<List<String>>) {
        this.destinationPorts = value
    }

    @JvmName("rvrerntjerpujaks")
    public suspend fun destinationPorts(vararg values: Output<String>) {
        this.destinationPorts = Output.all(values.asList())
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("ufbfpfmngkxrhnba")
    public suspend fun destinationPorts(values: List<Output<String>>) {
        this.destinationPorts = Output.all(values)
    }

    /**
     * @param value Name of the NAT rule.
     */
    @JvmName("msesyupebkhmmhxr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
     */
    @JvmName("qcvminejvycxjiym")
    public suspend
    fun protocols(`value`: Output<List<Either<String, AzureFirewallNetworkRuleProtocol>>>) {
        this.protocols = value
    }

    @JvmName("nxclmuckelxqpupc")
    public suspend fun protocols(
        vararg
        values: Output<Either<String, AzureFirewallNetworkRuleProtocol>>,
    ) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
     */
    @JvmName("uninbxjsbhxxbcio")
    public suspend
    fun protocols(values: List<Output<Either<String, AzureFirewallNetworkRuleProtocol>>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("uqitcckljgnhyxee")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("mgoydrtcibiufiyy")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("rfmxhchkdwxswxgy")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("npuxeancbjfjtolk")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("pjvckmyuaksauejk")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("dnxvdusrdshkwrpb")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value The translated address for this NAT rule.
     */
    @JvmName("lmedvebvdsatoktb")
    public suspend fun translatedAddress(`value`: Output<String>) {
        this.translatedAddress = value
    }

    /**
     * @param value The translated FQDN for this NAT rule.
     */
    @JvmName("ayfbxboqdjprfnvp")
    public suspend fun translatedFqdn(`value`: Output<String>) {
        this.translatedFqdn = value
    }

    /**
     * @param value The translated port for this NAT rule.
     */
    @JvmName("hytieauudvrrbxbv")
    public suspend fun translatedPort(`value`: Output<String>) {
        this.translatedPort = value
    }

    /**
     * @param value Description of the rule.
     */
    @JvmName("wijvjcrhnbqbyxre")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
     */
    @JvmName("bqepjxahbwvmahlg")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
     */
    @JvmName("vjcbartigxeqgnym")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("sjdbcmoqoufsvdvj")
    public suspend fun destinationPorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("eymjmbemfcipafya")
    public suspend fun destinationPorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param value Name of the NAT rule.
     */
    @JvmName("ygtuxwlydcsdogsm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
     */
    @JvmName("shgueieeuvjuvtjx")
    public suspend fun protocols(`value`: List<Either<String, AzureFirewallNetworkRuleProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param values Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
     */
    @JvmName("njwwpnfweliotrhv")
    public suspend fun protocols(vararg values: Either<String, AzureFirewallNetworkRuleProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("uqlaimpnhcfybpdh")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("ydpahsqjukbtuthn")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("bpgficfaxgtglper")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("apdmctgkgosmofrl")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param value The translated address for this NAT rule.
     */
    @JvmName("bjruhtjydxbhttft")
    public suspend fun translatedAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translatedAddress = mapped
    }

    /**
     * @param value The translated FQDN for this NAT rule.
     */
    @JvmName("nfrpslqcdbqicmnj")
    public suspend fun translatedFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translatedFqdn = mapped
    }

    /**
     * @param value The translated port for this NAT rule.
     */
    @JvmName("satjqfkqhkbffgfn")
    public suspend fun translatedPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translatedPort = mapped
    }

    internal fun build(): AzureFirewallNatRuleArgs = AzureFirewallNatRuleArgs(
        description = description,
        destinationAddresses = destinationAddresses,
        destinationPorts = destinationPorts,
        name = name,
        protocols = protocols,
        sourceAddresses = sourceAddresses,
        sourceIpGroups = sourceIpGroups,
        translatedAddress = translatedAddress,
        translatedFqdn = translatedFqdn,
        translatedPort = translatedPort,
    )
}
