@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallNetworkRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AzureFirewallNetworkRuleProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of the network rule.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses.
 * @property destinationFqdns List of destination FQDNs.
 * @property destinationIpGroups List of destination IpGroups for this rule.
 * @property destinationPorts List of destination ports.
 * @property name Name of the network rule.
 * @property protocols Array of AzureFirewallNetworkRuleProtocols.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 */
public data class AzureFirewallNetworkRuleArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val destinationFqdns: Output<List<String>>? = null,
    public val destinationIpGroups: Output<List<String>>? = null,
    public val destinationPorts: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val protocols: Output<List<Either<String, AzureFirewallNetworkRuleProtocol>>>? = null,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AzureFirewallNetworkRuleArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallNetworkRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationFqdns(destinationFqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationIpGroups(destinationIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationPorts(destinationPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocols(
                protocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AzureFirewallNetworkRuleArgs].
 */
@PulumiTagMarker
public class AzureFirewallNetworkRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var destinationFqdns: Output<List<String>>? = null

    private var destinationIpGroups: Output<List<String>>? = null

    private var destinationPorts: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var protocols: Output<List<Either<String, AzureFirewallNetworkRuleProtocol>>>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    /**
     * @param value Description of the rule.
     */
    @JvmName("ochgyvfbffptnrnb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses.
     */
    @JvmName("dmpeqyckxoguorix")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("pjnsqqcklhxxujma")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses.
     */
    @JvmName("phivncduuypunhyy")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of destination FQDNs.
     */
    @JvmName("fkdqrdmqlytmlkvn")
    public suspend fun destinationFqdns(`value`: Output<List<String>>) {
        this.destinationFqdns = value
    }

    @JvmName("fmvsxddmxsgmrrmb")
    public suspend fun destinationFqdns(vararg values: Output<String>) {
        this.destinationFqdns = Output.all(values.asList())
    }

    /**
     * @param values List of destination FQDNs.
     */
    @JvmName("rfenwichgarhtose")
    public suspend fun destinationFqdns(values: List<Output<String>>) {
        this.destinationFqdns = Output.all(values)
    }

    /**
     * @param value List of destination IpGroups for this rule.
     */
    @JvmName("ndiuymffyhuyfgif")
    public suspend fun destinationIpGroups(`value`: Output<List<String>>) {
        this.destinationIpGroups = value
    }

    @JvmName("abouwxjdtvududtb")
    public suspend fun destinationIpGroups(vararg values: Output<String>) {
        this.destinationIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of destination IpGroups for this rule.
     */
    @JvmName("iiifltdrguebqihw")
    public suspend fun destinationIpGroups(values: List<Output<String>>) {
        this.destinationIpGroups = Output.all(values)
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("cshvunushapekfpn")
    public suspend fun destinationPorts(`value`: Output<List<String>>) {
        this.destinationPorts = value
    }

    @JvmName("kcwdkeomhglxejxm")
    public suspend fun destinationPorts(vararg values: Output<String>) {
        this.destinationPorts = Output.all(values.asList())
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("rssipvrdyhbnohbn")
    public suspend fun destinationPorts(values: List<Output<String>>) {
        this.destinationPorts = Output.all(values)
    }

    /**
     * @param value Name of the network rule.
     */
    @JvmName("mejsqcvumgjvgbbb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Array of AzureFirewallNetworkRuleProtocols.
     */
    @JvmName("yodymectqaooogty")
    public suspend
    fun protocols(`value`: Output<List<Either<String, AzureFirewallNetworkRuleProtocol>>>) {
        this.protocols = value
    }

    @JvmName("iwfgeokwdjoeucad")
    public suspend fun protocols(
        vararg
        values: Output<Either<String, AzureFirewallNetworkRuleProtocol>>,
    ) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values Array of AzureFirewallNetworkRuleProtocols.
     */
    @JvmName("sygucwkvktlrdtdd")
    public suspend
    fun protocols(values: List<Output<Either<String, AzureFirewallNetworkRuleProtocol>>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("yrovnyymxlcisbdg")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("rquwgxkouguficxx")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("uttavruulnkbpueb")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("sdwwaghwbbeqkxqc")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("hxffguahkawtbrag")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("imrpxokbvrsayagr")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value Description of the rule.
     */
    @JvmName("tjjiwhojlmlhgybd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses.
     */
    @JvmName("mbyglyopguwmkrtk")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses.
     */
    @JvmName("atlqpiphwggjeikj")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of destination FQDNs.
     */
    @JvmName("ajbsakekcefdunup")
    public suspend fun destinationFqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationFqdns = mapped
    }

    /**
     * @param values List of destination FQDNs.
     */
    @JvmName("klbfgfuefaskrcgo")
    public suspend fun destinationFqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationFqdns = mapped
    }

    /**
     * @param value List of destination IpGroups for this rule.
     */
    @JvmName("fpchuvkdtxnlaiby")
    public suspend fun destinationIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIpGroups = mapped
    }

    /**
     * @param values List of destination IpGroups for this rule.
     */
    @JvmName("oervmdakqqkrpkka")
    public suspend fun destinationIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationIpGroups = mapped
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("nawfbbnvnriutumi")
    public suspend fun destinationPorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("lrhpqtpqwhuyttss")
    public suspend fun destinationPorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param value Name of the network rule.
     */
    @JvmName("iqosborxlvkhrghr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Array of AzureFirewallNetworkRuleProtocols.
     */
    @JvmName("rrplwbigyfmhneoe")
    public suspend fun protocols(`value`: List<Either<String, AzureFirewallNetworkRuleProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param values Array of AzureFirewallNetworkRuleProtocols.
     */
    @JvmName("tomyctoibpqpmiyq")
    public suspend fun protocols(vararg values: Either<String, AzureFirewallNetworkRuleProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("cldpaxgdynnnajtf")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("jeqmrukpeersldnm")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("swpnpvkfiethwviu")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("wlvoylhrfxcpfbst")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    internal fun build(): AzureFirewallNetworkRuleArgs = AzureFirewallNetworkRuleArgs(
        description = description,
        destinationAddresses = destinationAddresses,
        destinationFqdns = destinationFqdns,
        destinationIpGroups = destinationIpGroups,
        destinationPorts = destinationPorts,
        name = name,
        protocols = protocols,
        sourceAddresses = sourceAddresses,
        sourceIpGroups = sourceIpGroups,
    )
}
