@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallNetworkRuleCollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network rule collection resource.
 * @property action The action type of a rule collection.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
 * @property priority Priority of the network rule collection resource.
 * @property rules Collection of rules used by a network rule collection.
 */
public data class AzureFirewallNetworkRuleCollectionArgs(
    public val action: Output<AzureFirewallRCActionArgs>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val rules: Output<List<AzureFirewallNetworkRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallNetworkRuleCollectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.AzureFirewallNetworkRuleCollectionArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallNetworkRuleCollectionArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureFirewallNetworkRuleCollectionArgs].
 */
@PulumiTagMarker
public class AzureFirewallNetworkRuleCollectionArgsBuilder internal constructor() {
    private var action: Output<AzureFirewallRCActionArgs>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var rules: Output<List<AzureFirewallNetworkRuleArgs>>? = null

    /**
     * @param value The action type of a rule collection.
     */
    @JvmName("knyfvhnurktwpxxq")
    public suspend fun action(`value`: Output<AzureFirewallRCActionArgs>) {
        this.action = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ktgdbxalxqlnvbfu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
     */
    @JvmName("okehnnopvfiuqfet")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the network rule collection resource.
     */
    @JvmName("maqvjthoiodaijyk")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Collection of rules used by a network rule collection.
     */
    @JvmName("kraovcuoantjyrfu")
    public suspend fun rules(`value`: Output<List<AzureFirewallNetworkRuleArgs>>) {
        this.rules = value
    }

    @JvmName("kchnhembdcjcwkqg")
    public suspend fun rules(vararg values: Output<AzureFirewallNetworkRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Collection of rules used by a network rule collection.
     */
    @JvmName("wucxfkkgcdjkmlhr")
    public suspend fun rules(values: List<Output<AzureFirewallNetworkRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The action type of a rule collection.
     */
    @JvmName("xuoxlnxvhrqppfvg")
    public suspend fun action(`value`: AzureFirewallRCActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action type of a rule collection.
     */
    @JvmName("jobfdxqnyhlotnsu")
    public suspend fun action(argument: suspend AzureFirewallRCActionArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFirewallRCActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("foxipithhchnjhrx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
     */
    @JvmName("eshslcmmavglvlxt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the network rule collection resource.
     */
    @JvmName("unfrbcxuehsrcxdi")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Collection of rules used by a network rule collection.
     */
    @JvmName("byegbmtnutvohsoa")
    public suspend fun rules(`value`: List<AzureFirewallNetworkRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Collection of rules used by a network rule collection.
     */
    @JvmName("eglphlbjbqhiikab")
    public suspend fun rules(argument: List<suspend AzureFirewallNetworkRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFirewallNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Collection of rules used by a network rule collection.
     */
    @JvmName("isjcwwesvjuvkqfq")
    public suspend fun rules(
        vararg
        argument: suspend AzureFirewallNetworkRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureFirewallNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Collection of rules used by a network rule collection.
     */
    @JvmName("fxidvtllkdavxyay")
    public suspend fun rules(argument: suspend AzureFirewallNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureFirewallNetworkRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Collection of rules used by a network rule collection.
     */
    @JvmName("bphrphxawthbdxyu")
    public suspend fun rules(vararg values: AzureFirewallNetworkRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): AzureFirewallNetworkRuleCollectionArgs =
        AzureFirewallNetworkRuleCollectionArgs(
            action = action,
            id = id,
            name = name,
            priority = priority,
            rules = rules,
        )
}
