@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallRCActionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AzureFirewallRCActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the AzureFirewallRCAction.
 * @property type The type of action.
 */
public data class AzureFirewallRCActionArgs(
    public val type: Output<Either<String, AzureFirewallRCActionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallRCActionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AzureFirewallRCActionArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallRCActionArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureFirewallRCActionArgs].
 */
@PulumiTagMarker
public class AzureFirewallRCActionArgsBuilder internal constructor() {
    private var type: Output<Either<String, AzureFirewallRCActionType>>? = null

    /**
     * @param value The type of action.
     */
    @JvmName("ttljhjwlfuixyius")
    public suspend fun type(`value`: Output<Either<String, AzureFirewallRCActionType>>) {
        this.type = value
    }

    /**
     * @param value The type of action.
     */
    @JvmName("dybrgubawwkegyxi")
    public suspend fun type(`value`: Either<String, AzureFirewallRCActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("taxujqbygbdirajo")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureFirewallRCActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("kqthrnriiwmnqpcg")
    public fun type(`value`: AzureFirewallRCActionType) {
        val toBeMapped = Either.ofRight<String, AzureFirewallRCActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureFirewallRCActionArgs = AzureFirewallRCActionArgs(
        type = type,
    )
}
