@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.BastionShareableLink.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Bastion Shareable Link.
 * @property vm Reference of the virtual machine resource.
 */
public data class BastionShareableLink(
    public val vm: VM,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.BastionShareableLink> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.BastionShareableLink =
        com.pulumi.azurenative.network.inputs.BastionShareableLink.builder()
            .vm(vm.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BastionShareableLink].
 */
@PulumiTagMarker
public class BastionShareableLinkBuilder internal constructor() {
    private var vm: VM? = null

    /**
     * @param value Reference of the virtual machine resource.
     */
    @JvmName("xmdihqobvcwqrega")
    public suspend fun vm(`value`: VM) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vm = mapped
    }

    /**
     * @param argument Reference of the virtual machine resource.
     */
    @JvmName("fbtrcyakvgljxkjx")
    public suspend fun vm(argument: suspend VMBuilder.() -> Unit) {
        val toBeMapped = VMBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.vm = mapped
    }

    internal fun build(): BastionShareableLink = BastionShareableLink(
        vm = vm ?: throw PulumiNullFieldException("vm"),
    )
}
