@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.CaaRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A CAA record.
 * @property flags The flags for this CAA record as an integer between 0 and 255.
 * @property tag The tag for this CAA record.
 * @property value The value for this CAA record.
 */
public data class CaaRecordArgs(
    public val flags: Output<Int>? = null,
    public val tag: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.CaaRecordArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.CaaRecordArgs =
        com.pulumi.azurenative.network.inputs.CaaRecordArgs.builder()
            .flags(flags?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CaaRecordArgs].
 */
@PulumiTagMarker
public class CaaRecordArgsBuilder internal constructor() {
    private var flags: Output<Int>? = null

    private var tag: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The flags for this CAA record as an integer between 0 and 255.
     */
    @JvmName("lpoddfptteeivjwg")
    public suspend fun flags(`value`: Output<Int>) {
        this.flags = value
    }

    /**
     * @param value The tag for this CAA record.
     */
    @JvmName("wlttwsywclwkripm")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value The value for this CAA record.
     */
    @JvmName("ddgaqdoqactibnvw")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The flags for this CAA record as an integer between 0 and 255.
     */
    @JvmName("ldmcwlaaelhwbppj")
    public suspend fun flags(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flags = mapped
    }

    /**
     * @param value The tag for this CAA record.
     */
    @JvmName("nagotshjkhquejxu")
    public suspend fun tag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param value The value for this CAA record.
     */
    @JvmName("xlwruborhkeuqdof")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): CaaRecordArgs = CaaRecordArgs(
        flags = flags,
        tag = tag,
        `value` = `value`,
    )
}
