@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorTestConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ConnectionMonitorTestConfigurationProtocol
import com.pulumi.azurenative.network.kotlin.enums.PreferredIPVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a connection monitor test configuration.
 * @property httpConfiguration The parameters used to perform test evaluation over HTTP.
 * @property icmpConfiguration The parameters used to perform test evaluation over ICMP.
 * @property name The name of the connection monitor test configuration.
 * @property preferredIPVersion The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
 * @property protocol The protocol to use in test evaluation.
 * @property successThreshold The threshold for declaring a test successful.
 * @property tcpConfiguration The parameters used to perform test evaluation over TCP.
 * @property testFrequencySec The frequency of test evaluation, in seconds.
 */
public data class ConnectionMonitorTestConfigurationArgs(
    public val httpConfiguration: Output<ConnectionMonitorHttpConfigurationArgs>? = null,
    public val icmpConfiguration: Output<ConnectionMonitorIcmpConfigurationArgs>? = null,
    public val name: Output<String>,
    public val preferredIPVersion: Output<Either<String, PreferredIPVersion>>? = null,
    public val protocol: Output<Either<String, ConnectionMonitorTestConfigurationProtocol>>,
    public val successThreshold: Output<ConnectionMonitorSuccessThresholdArgs>? = null,
    public val tcpConfiguration: Output<ConnectionMonitorTcpConfigurationArgs>? = null,
    public val testFrequencySec: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorTestConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ConnectionMonitorTestConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorTestConfigurationArgs.builder()
            .httpConfiguration(httpConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .icmpConfiguration(icmpConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .preferredIPVersion(
                preferredIPVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .successThreshold(successThreshold?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tcpConfiguration(tcpConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .testFrequencySec(testFrequencySec?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionMonitorTestConfigurationArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorTestConfigurationArgsBuilder internal constructor() {
    private var httpConfiguration: Output<ConnectionMonitorHttpConfigurationArgs>? = null

    private var icmpConfiguration: Output<ConnectionMonitorIcmpConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var preferredIPVersion: Output<Either<String, PreferredIPVersion>>? = null

    private var protocol: Output<Either<String, ConnectionMonitorTestConfigurationProtocol>>? = null

    private var successThreshold: Output<ConnectionMonitorSuccessThresholdArgs>? = null

    private var tcpConfiguration: Output<ConnectionMonitorTcpConfigurationArgs>? = null

    private var testFrequencySec: Output<Int>? = null

    /**
     * @param value The parameters used to perform test evaluation over HTTP.
     */
    @JvmName("titexrainpndjede")
    public suspend fun httpConfiguration(`value`: Output<ConnectionMonitorHttpConfigurationArgs>) {
        this.httpConfiguration = value
    }

    /**
     * @param value The parameters used to perform test evaluation over ICMP.
     */
    @JvmName("xjfwpbnacgkueviw")
    public suspend fun icmpConfiguration(`value`: Output<ConnectionMonitorIcmpConfigurationArgs>) {
        this.icmpConfiguration = value
    }

    /**
     * @param value The name of the connection monitor test configuration.
     */
    @JvmName("chmmeaiuvvbawapk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
     */
    @JvmName("mwqocynwexxtasbl")
    public suspend fun preferredIPVersion(`value`: Output<Either<String, PreferredIPVersion>>) {
        this.preferredIPVersion = value
    }

    /**
     * @param value The protocol to use in test evaluation.
     */
    @JvmName("wvpolobcspptkpon")
    public suspend
    fun protocol(`value`: Output<Either<String, ConnectionMonitorTestConfigurationProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The threshold for declaring a test successful.
     */
    @JvmName("rljbfyhxpgtdmygy")
    public suspend fun successThreshold(`value`: Output<ConnectionMonitorSuccessThresholdArgs>) {
        this.successThreshold = value
    }

    /**
     * @param value The parameters used to perform test evaluation over TCP.
     */
    @JvmName("utwkgjfnjgdexbwn")
    public suspend fun tcpConfiguration(`value`: Output<ConnectionMonitorTcpConfigurationArgs>) {
        this.tcpConfiguration = value
    }

    /**
     * @param value The frequency of test evaluation, in seconds.
     */
    @JvmName("mgnwfwjgjfmsknwi")
    public suspend fun testFrequencySec(`value`: Output<Int>) {
        this.testFrequencySec = value
    }

    /**
     * @param value The parameters used to perform test evaluation over HTTP.
     */
    @JvmName("arkllhbkkxgudrex")
    public suspend fun httpConfiguration(`value`: ConnectionMonitorHttpConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpConfiguration = mapped
    }

    /**
     * @param argument The parameters used to perform test evaluation over HTTP.
     */
    @JvmName("iamfeehqysvmspil")
    public suspend
    fun httpConfiguration(argument: suspend ConnectionMonitorHttpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionMonitorHttpConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.httpConfiguration = mapped
    }

    /**
     * @param value The parameters used to perform test evaluation over ICMP.
     */
    @JvmName("ihdpyigbxwgrygox")
    public suspend fun icmpConfiguration(`value`: ConnectionMonitorIcmpConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icmpConfiguration = mapped
    }

    /**
     * @param argument The parameters used to perform test evaluation over ICMP.
     */
    @JvmName("eusadylcqdpkfcnl")
    public suspend
    fun icmpConfiguration(argument: suspend ConnectionMonitorIcmpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionMonitorIcmpConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.icmpConfiguration = mapped
    }

    /**
     * @param value The name of the connection monitor test configuration.
     */
    @JvmName("yhjitcvrjktsydmp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
     */
    @JvmName("dpfniwdrmgjnoqwx")
    public suspend fun preferredIPVersion(`value`: Either<String, PreferredIPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredIPVersion = mapped
    }

    /**
     * @param value The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
     */
    @JvmName("kcxifoppeqtvsinp")
    public fun preferredIPVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PreferredIPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredIPVersion = mapped
    }

    /**
     * @param value The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
     */
    @JvmName("xeqocxbolxoduuls")
    public fun preferredIPVersion(`value`: PreferredIPVersion) {
        val toBeMapped = Either.ofRight<String, PreferredIPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredIPVersion = mapped
    }

    /**
     * @param value The protocol to use in test evaluation.
     */
    @JvmName("ebxdlgfrdvmvckpe")
    public suspend fun protocol(`value`: Either<String, ConnectionMonitorTestConfigurationProtocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol to use in test evaluation.
     */
    @JvmName("haskldpinqywnvym")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionMonitorTestConfigurationProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol to use in test evaluation.
     */
    @JvmName("kmwujjekqrcdevme")
    public fun protocol(`value`: ConnectionMonitorTestConfigurationProtocol) {
        val toBeMapped = Either.ofRight<String, ConnectionMonitorTestConfigurationProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The threshold for declaring a test successful.
     */
    @JvmName("ydinhfqbixtqvdwl")
    public suspend fun successThreshold(`value`: ConnectionMonitorSuccessThresholdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successThreshold = mapped
    }

    /**
     * @param argument The threshold for declaring a test successful.
     */
    @JvmName("xniagtxwennxaosf")
    public suspend
    fun successThreshold(argument: suspend ConnectionMonitorSuccessThresholdArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionMonitorSuccessThresholdArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.successThreshold = mapped
    }

    /**
     * @param value The parameters used to perform test evaluation over TCP.
     */
    @JvmName("kfaleenhxatdlsop")
    public suspend fun tcpConfiguration(`value`: ConnectionMonitorTcpConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpConfiguration = mapped
    }

    /**
     * @param argument The parameters used to perform test evaluation over TCP.
     */
    @JvmName("yewcqfvefurqmhdd")
    public suspend
    fun tcpConfiguration(argument: suspend ConnectionMonitorTcpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionMonitorTcpConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tcpConfiguration = mapped
    }

    /**
     * @param value The frequency of test evaluation, in seconds.
     */
    @JvmName("bajkfdtgblqyrexv")
    public suspend fun testFrequencySec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testFrequencySec = mapped
    }

    internal fun build(): ConnectionMonitorTestConfigurationArgs =
        ConnectionMonitorTestConfigurationArgs(
            httpConfiguration = httpConfiguration,
            icmpConfiguration = icmpConfiguration,
            name = name ?: throw PulumiNullFieldException("name"),
            preferredIPVersion = preferredIPVersion,
            protocol = protocol ?: throw PulumiNullFieldException("protocol"),
            successThreshold = successThreshold,
            tcpConfiguration = tcpConfiguration,
            testFrequencySec = testFrequencySec,
        )
}
