@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.CustomRuleListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines contents of custom rules
 * @property rules List of rules
 */
public data class CustomRuleListArgs(
    public val rules: Output<List<CustomRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.CustomRuleListArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.CustomRuleListArgs =
        com.pulumi.azurenative.network.inputs.CustomRuleListArgs.builder()
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomRuleListArgs].
 */
@PulumiTagMarker
public class CustomRuleListArgsBuilder internal constructor() {
    private var rules: Output<List<CustomRuleArgs>>? = null

    /**
     * @param value List of rules
     */
    @JvmName("ksximqxijjyuhyor")
    public suspend fun rules(`value`: Output<List<CustomRuleArgs>>) {
        this.rules = value
    }

    @JvmName("pltragufnxpngcfe")
    public suspend fun rules(vararg values: Output<CustomRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of rules
     */
    @JvmName("krwvdhedyfiptxvc")
    public suspend fun rules(values: List<Output<CustomRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value List of rules
     */
    @JvmName("uiyidtsmtwtmohao")
    public suspend fun rules(`value`: List<CustomRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument List of rules
     */
    @JvmName("usvenvtpruiejrvj")
    public suspend fun rules(argument: List<suspend CustomRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CustomRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules
     */
    @JvmName("qxhunicooymytmri")
    public suspend fun rules(vararg argument: suspend CustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CustomRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules
     */
    @JvmName("tdxhwgtttwgnqkyc")
    public suspend fun rules(argument: suspend CustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CustomRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values List of rules
     */
    @JvmName("duflqdupprtxqsyu")
    public suspend fun rules(vararg values: CustomRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): CustomRuleListArgs = CustomRuleListArgs(
        rules = rules,
    )
}
