@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteCircuitConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
 * @property addressPrefix /29 IP address space to carve out Customer addresses for tunnels.
 * @property authorizationKey The authorization key.
 * @property expressRouteCircuitPeering Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
 * @property id Resource ID.
 * @property ipv6CircuitConnectionConfig IPv6 Address PrefixProperties of the express route circuit connection.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property peerExpressRouteCircuitPeering Reference to Express Route Circuit Private Peering Resource of the peered circuit.
 */
public data class ExpressRouteCircuitConnectionArgs(
    public val addressPrefix: Output<String>? = null,
    public val authorizationKey: Output<String>? = null,
    public val expressRouteCircuitPeering: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val ipv6CircuitConnectionConfig: Output<Ipv6CircuitConnectionConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val peerExpressRouteCircuitPeering: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteCircuitConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExpressRouteCircuitConnectionArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteCircuitConnectionArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .authorizationKey(authorizationKey?.applyValue({ args0 -> args0 }))
            .expressRouteCircuitPeering(
                expressRouteCircuitPeering?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .ipv6CircuitConnectionConfig(
                ipv6CircuitConnectionConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .peerExpressRouteCircuitPeering(
                peerExpressRouteCircuitPeering?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [ExpressRouteCircuitConnectionArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitConnectionArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var authorizationKey: Output<String>? = null

    private var expressRouteCircuitPeering: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var ipv6CircuitConnectionConfig: Output<Ipv6CircuitConnectionConfigArgs>? = null

    private var name: Output<String>? = null

    private var peerExpressRouteCircuitPeering: Output<SubResourceArgs>? = null

    /**
     * @param value /29 IP address space to carve out Customer addresses for tunnels.
     */
    @JvmName("oshaxbhmcqiyecnm")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value The authorization key.
     */
    @JvmName("bkuekxwcufietwxi")
    public suspend fun authorizationKey(`value`: Output<String>) {
        this.authorizationKey = value
    }

    /**
     * @param value Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
     */
    @JvmName("nnldoxotrggfocdc")
    public suspend fun expressRouteCircuitPeering(`value`: Output<SubResourceArgs>) {
        this.expressRouteCircuitPeering = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pfcyqmxbencfjave")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value IPv6 Address PrefixProperties of the express route circuit connection.
     */
    @JvmName("katypkthiunhrevi")
    public suspend fun ipv6CircuitConnectionConfig(`value`: Output<Ipv6CircuitConnectionConfigArgs>) {
        this.ipv6CircuitConnectionConfig = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("vmppxmpjxdueoirx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reference to Express Route Circuit Private Peering Resource of the peered circuit.
     */
    @JvmName("npqmlkerxcuwadoo")
    public suspend fun peerExpressRouteCircuitPeering(`value`: Output<SubResourceArgs>) {
        this.peerExpressRouteCircuitPeering = value
    }

    /**
     * @param value /29 IP address space to carve out Customer addresses for tunnels.
     */
    @JvmName("lxwbpmboodxaobjd")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value The authorization key.
     */
    @JvmName("hrttegqkhlvjfeim")
    public suspend fun authorizationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationKey = mapped
    }

    /**
     * @param value Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
     */
    @JvmName("kidirpptmtdatsao")
    public suspend fun expressRouteCircuitPeering(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteCircuitPeering = mapped
    }

    /**
     * @param argument Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
     */
    @JvmName("vdbdrnveqhxpiemh")
    public suspend
    fun expressRouteCircuitPeering(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.expressRouteCircuitPeering = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dqkdjkbpfsavfgcf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value IPv6 Address PrefixProperties of the express route circuit connection.
     */
    @JvmName("yjbuwgbqbbakcumu")
    public suspend fun ipv6CircuitConnectionConfig(`value`: Ipv6CircuitConnectionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CircuitConnectionConfig = mapped
    }

    /**
     * @param argument IPv6 Address PrefixProperties of the express route circuit connection.
     */
    @JvmName("ikpcxoejfwcjriei")
    public suspend
    fun ipv6CircuitConnectionConfig(argument: suspend Ipv6CircuitConnectionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = Ipv6CircuitConnectionConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipv6CircuitConnectionConfig = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("qfofsvalygasjefp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reference to Express Route Circuit Private Peering Resource of the peered circuit.
     */
    @JvmName("veoovefpjehocsdq")
    public suspend fun peerExpressRouteCircuitPeering(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerExpressRouteCircuitPeering = mapped
    }

    /**
     * @param argument Reference to Express Route Circuit Private Peering Resource of the peered circuit.
     */
    @JvmName("madiinwaswqmrqjq")
    public suspend
    fun peerExpressRouteCircuitPeering(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peerExpressRouteCircuitPeering = mapped
    }

    internal fun build(): ExpressRouteCircuitConnectionArgs = ExpressRouteCircuitConnectionArgs(
        addressPrefix = addressPrefix,
        authorizationKey = authorizationKey,
        expressRouteCircuitPeering = expressRouteCircuitPeering,
        id = id,
        ipv6CircuitConnectionConfig = ipv6CircuitConnectionConfig,
        name = name,
        peerExpressRouteCircuitPeering = peerExpressRouteCircuitPeering,
    )
}
