@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ExpressRoute circuit peering identifier.
 * @property id The ID of the ExpressRoute circuit peering.
 */
public data class ExpressRouteCircuitPeeringIdArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringIdArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringIdArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringIdArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteCircuitPeeringIdArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitPeeringIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The ID of the ExpressRoute circuit peering.
     */
    @JvmName("cyrbwqolkhdivlut")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The ID of the ExpressRoute circuit peering.
     */
    @JvmName("rbvjpgbctttgwsqx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ExpressRouteCircuitPeeringIdArgs = ExpressRouteCircuitPeeringIdArgs(
        id = id,
    )
}
