@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteCircuitStatsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains stats associated with the peering.
 * @property primarybytesIn The Primary BytesIn of the peering.
 * @property primarybytesOut The primary BytesOut of the peering.
 * @property secondarybytesIn The secondary BytesIn of the peering.
 * @property secondarybytesOut The secondary BytesOut of the peering.
 */
public data class ExpressRouteCircuitStatsArgs(
    public val primarybytesIn: Output<Double>? = null,
    public val primarybytesOut: Output<Double>? = null,
    public val secondarybytesIn: Output<Double>? = null,
    public val secondarybytesOut: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteCircuitStatsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExpressRouteCircuitStatsArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteCircuitStatsArgs.builder()
            .primarybytesIn(primarybytesIn?.applyValue({ args0 -> args0 }))
            .primarybytesOut(primarybytesOut?.applyValue({ args0 -> args0 }))
            .secondarybytesIn(secondarybytesIn?.applyValue({ args0 -> args0 }))
            .secondarybytesOut(secondarybytesOut?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteCircuitStatsArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitStatsArgsBuilder internal constructor() {
    private var primarybytesIn: Output<Double>? = null

    private var primarybytesOut: Output<Double>? = null

    private var secondarybytesIn: Output<Double>? = null

    private var secondarybytesOut: Output<Double>? = null

    /**
     * @param value The Primary BytesIn of the peering.
     */
    @JvmName("qvxjlybmpnpjkeum")
    public suspend fun primarybytesIn(`value`: Output<Double>) {
        this.primarybytesIn = value
    }

    /**
     * @param value The primary BytesOut of the peering.
     */
    @JvmName("ueiwaawmjkdywryk")
    public suspend fun primarybytesOut(`value`: Output<Double>) {
        this.primarybytesOut = value
    }

    /**
     * @param value The secondary BytesIn of the peering.
     */
    @JvmName("nleibkltgjawwfcj")
    public suspend fun secondarybytesIn(`value`: Output<Double>) {
        this.secondarybytesIn = value
    }

    /**
     * @param value The secondary BytesOut of the peering.
     */
    @JvmName("aymmaykyirciyqej")
    public suspend fun secondarybytesOut(`value`: Output<Double>) {
        this.secondarybytesOut = value
    }

    /**
     * @param value The Primary BytesIn of the peering.
     */
    @JvmName("qgecjxkaomfsywen")
    public suspend fun primarybytesIn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primarybytesIn = mapped
    }

    /**
     * @param value The primary BytesOut of the peering.
     */
    @JvmName("gmpqrrpxxbxufcqw")
    public suspend fun primarybytesOut(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primarybytesOut = mapped
    }

    /**
     * @param value The secondary BytesIn of the peering.
     */
    @JvmName("tfaiesjyduqaxiyk")
    public suspend fun secondarybytesIn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondarybytesIn = mapped
    }

    /**
     * @param value The secondary BytesOut of the peering.
     */
    @JvmName("uojqdvotenejwpmy")
    public suspend fun secondarybytesOut(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondarybytesOut = mapped
    }

    internal fun build(): ExpressRouteCircuitStatsArgs = ExpressRouteCircuitStatsArgs(
        primarybytesIn = primarybytesIn,
        primarybytesOut = primarybytesOut,
        secondarybytesIn = secondarybytesIn,
        secondarybytesOut = secondarybytesOut,
    )
}
