@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyInsightsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Firewall Policy Insights.
 * @property isEnabled A flag to indicate if the insights are enabled on the policy.
 * @property logAnalyticsResources Workspaces needed to configure the Firewall Policy Insights.
 * @property retentionDays Number of days the insights should be enabled on the policy.
 */
public data class FirewallPolicyInsightsArgs(
    public val isEnabled: Output<Boolean>? = null,
    public val logAnalyticsResources: Output<FirewallPolicyLogAnalyticsResourcesArgs>? = null,
    public val retentionDays: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyInsightsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyInsightsArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyInsightsArgs.builder()
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .logAnalyticsResources(
                logAnalyticsResources?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicyInsightsArgs].
 */
@PulumiTagMarker
public class FirewallPolicyInsightsArgsBuilder internal constructor() {
    private var isEnabled: Output<Boolean>? = null

    private var logAnalyticsResources: Output<FirewallPolicyLogAnalyticsResourcesArgs>? = null

    private var retentionDays: Output<Int>? = null

    /**
     * @param value A flag to indicate if the insights are enabled on the policy.
     */
    @JvmName("vgvpeunobsvttjkc")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Workspaces needed to configure the Firewall Policy Insights.
     */
    @JvmName("jfffpjrveauwoxcm")
    public suspend
    fun logAnalyticsResources(`value`: Output<FirewallPolicyLogAnalyticsResourcesArgs>) {
        this.logAnalyticsResources = value
    }

    /**
     * @param value Number of days the insights should be enabled on the policy.
     */
    @JvmName("klfeurkbtehkoclb")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value A flag to indicate if the insights are enabled on the policy.
     */
    @JvmName("cyhwscpehwgkqfmc")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Workspaces needed to configure the Firewall Policy Insights.
     */
    @JvmName("ysyayrjlrrxwcrwn")
    public suspend fun logAnalyticsResources(`value`: FirewallPolicyLogAnalyticsResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsResources = mapped
    }

    /**
     * @param argument Workspaces needed to configure the Firewall Policy Insights.
     */
    @JvmName("rjfkhjwdicfjacke")
    public suspend
    fun logAnalyticsResources(argument: suspend FirewallPolicyLogAnalyticsResourcesArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyLogAnalyticsResourcesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.logAnalyticsResources = mapped
    }

    /**
     * @param value Number of days the insights should be enabled on the policy.
     */
    @JvmName("blljkenmobyovdit")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    internal fun build(): FirewallPolicyInsightsArgs = FirewallPolicyInsightsArgs(
        isEnabled = isEnabled,
        logAnalyticsResources = logAnalyticsResources,
        retentionDays = retentionDays,
    )
}
