@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ForwardingConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FrontDoorForwardingProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes Forwarding Route.
 * @property backendPool A reference to the BackendPool which this rule routes to.
 * @property cacheConfiguration The caching configuration associated with this rule.
 * @property customForwardingPath A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
 * @property forwardingProtocol Protocol this rule will use when forwarding traffic to backends.
 * @property odataType
 * Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
 */
public data class ForwardingConfigurationArgs(
    public val backendPool: Output<SubResourceArgs>? = null,
    public val cacheConfiguration: Output<CacheConfigurationArgs>? = null,
    public val customForwardingPath: Output<String>? = null,
    public val forwardingProtocol: Output<Either<String, FrontDoorForwardingProtocol>>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ForwardingConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ForwardingConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ForwardingConfigurationArgs.builder()
            .backendPool(backendPool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cacheConfiguration(
                cacheConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customForwardingPath(customForwardingPath?.applyValue({ args0 -> args0 }))
            .forwardingProtocol(
                forwardingProtocol?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ForwardingConfigurationArgs].
 */
@PulumiTagMarker
public class ForwardingConfigurationArgsBuilder internal constructor() {
    private var backendPool: Output<SubResourceArgs>? = null

    private var cacheConfiguration: Output<CacheConfigurationArgs>? = null

    private var customForwardingPath: Output<String>? = null

    private var forwardingProtocol: Output<Either<String, FrontDoorForwardingProtocol>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value A reference to the BackendPool which this rule routes to.
     */
    @JvmName("rgvjwvcaeummmwmh")
    public suspend fun backendPool(`value`: Output<SubResourceArgs>) {
        this.backendPool = value
    }

    /**
     * @param value The caching configuration associated with this rule.
     */
    @JvmName("danoqidudrnwafjg")
    public suspend fun cacheConfiguration(`value`: Output<CacheConfigurationArgs>) {
        this.cacheConfiguration = value
    }

    /**
     * @param value A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
     */
    @JvmName("sdodapybrspgtgwh")
    public suspend fun customForwardingPath(`value`: Output<String>) {
        this.customForwardingPath = value
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("qwkbgvtxbjffuomt")
    public suspend
    fun forwardingProtocol(`value`: Output<Either<String, FrontDoorForwardingProtocol>>) {
        this.forwardingProtocol = value
    }

    /**
     * @param value
     * Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
     */
    @JvmName("etfdddypynprchbj")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value A reference to the BackendPool which this rule routes to.
     */
    @JvmName("sivgxqwtuoeapdiw")
    public suspend fun backendPool(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPool = mapped
    }

    /**
     * @param argument A reference to the BackendPool which this rule routes to.
     */
    @JvmName("rbtrevplrncvdsps")
    public suspend fun backendPool(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendPool = mapped
    }

    /**
     * @param value The caching configuration associated with this rule.
     */
    @JvmName("rnfalvfqnkqehhff")
    public suspend fun cacheConfiguration(`value`: CacheConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheConfiguration = mapped
    }

    /**
     * @param argument The caching configuration associated with this rule.
     */
    @JvmName("fmktdbnxdnkmsbwi")
    public suspend
    fun cacheConfiguration(argument: suspend CacheConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CacheConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cacheConfiguration = mapped
    }

    /**
     * @param value A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
     */
    @JvmName("nwgdxxqosamltbfx")
    public suspend fun customForwardingPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customForwardingPath = mapped
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("tblndcyiplyfexnp")
    public suspend fun forwardingProtocol(`value`: Either<String, FrontDoorForwardingProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardingProtocol = mapped
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("spbbbfxynjjogddh")
    public fun forwardingProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FrontDoorForwardingProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardingProtocol = mapped
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("dlwqvdxciyilejws")
    public fun forwardingProtocol(`value`: FrontDoorForwardingProtocol) {
        val toBeMapped = Either.ofRight<String, FrontDoorForwardingProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardingProtocol = mapped
    }

    /**
     * @param value
     * Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
     */
    @JvmName("shiaodvhrpbnueqj")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): ForwardingConfigurationArgs = ForwardingConfigurationArgs(
        backendPool = backendPool,
        cacheConfiguration = cacheConfiguration,
        customForwardingPath = customForwardingPath,
        forwardingProtocol = forwardingProtocol,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
