@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleSetArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ManagedRuleSetActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a managed rule set.
 * @property exclusions Describes the exclusions that are applied to all rules in the set.
 * @property ruleGroupOverrides Defines the rule group overrides to apply to the rule set.
 * @property ruleSetAction Defines the rule set action.
 * @property ruleSetType Defines the rule set type to use.
 * @property ruleSetVersion Defines the version of the rule set to use.
 */
public data class FrontDoorManagedRuleSetArgs(
    public val exclusions: Output<List<ManagedRuleExclusionArgs>>? = null,
    public val ruleGroupOverrides: Output<List<FrontDoorManagedRuleGroupOverrideArgs>>? = null,
    public val ruleSetAction: Output<Either<String, ManagedRuleSetActionType>>? = null,
    public val ruleSetType: Output<String>,
    public val ruleSetVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleSetArgs =
        com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleSetArgs.builder()
            .exclusions(
                exclusions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleGroupOverrides(
                ruleGroupOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ruleSetAction(
                ruleSetAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ruleSetType(ruleSetType.applyValue({ args0 -> args0 }))
            .ruleSetVersion(ruleSetVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FrontDoorManagedRuleSetArgs].
 */
@PulumiTagMarker
public class FrontDoorManagedRuleSetArgsBuilder internal constructor() {
    private var exclusions: Output<List<ManagedRuleExclusionArgs>>? = null

    private var ruleGroupOverrides: Output<List<FrontDoorManagedRuleGroupOverrideArgs>>? = null

    private var ruleSetAction: Output<Either<String, ManagedRuleSetActionType>>? = null

    private var ruleSetType: Output<String>? = null

    private var ruleSetVersion: Output<String>? = null

    /**
     * @param value Describes the exclusions that are applied to all rules in the set.
     */
    @JvmName("ypjxhmufmskedrpi")
    public suspend fun exclusions(`value`: Output<List<ManagedRuleExclusionArgs>>) {
        this.exclusions = value
    }

    @JvmName("onxrfwqssnmaxmbu")
    public suspend fun exclusions(vararg values: Output<ManagedRuleExclusionArgs>) {
        this.exclusions = Output.all(values.asList())
    }

    /**
     * @param values Describes the exclusions that are applied to all rules in the set.
     */
    @JvmName("nsxgbkprspihiabn")
    public suspend fun exclusions(values: List<Output<ManagedRuleExclusionArgs>>) {
        this.exclusions = Output.all(values)
    }

    /**
     * @param value Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("njiybxhcljbpuapt")
    public suspend
    fun ruleGroupOverrides(`value`: Output<List<FrontDoorManagedRuleGroupOverrideArgs>>) {
        this.ruleGroupOverrides = value
    }

    @JvmName("mexvcwtpsbdxtuah")
    public suspend fun ruleGroupOverrides(
        vararg
        values: Output<FrontDoorManagedRuleGroupOverrideArgs>,
    ) {
        this.ruleGroupOverrides = Output.all(values.asList())
    }

    /**
     * @param values Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("ukpoqcqkoutcodqi")
    public suspend
    fun ruleGroupOverrides(values: List<Output<FrontDoorManagedRuleGroupOverrideArgs>>) {
        this.ruleGroupOverrides = Output.all(values)
    }

    /**
     * @param value Defines the rule set action.
     */
    @JvmName("dannnjlbtllqrfte")
    public suspend fun ruleSetAction(`value`: Output<Either<String, ManagedRuleSetActionType>>) {
        this.ruleSetAction = value
    }

    /**
     * @param value Defines the rule set type to use.
     */
    @JvmName("deromveibiykhcng")
    public suspend fun ruleSetType(`value`: Output<String>) {
        this.ruleSetType = value
    }

    /**
     * @param value Defines the version of the rule set to use.
     */
    @JvmName("pvaguqqjahdbfwra")
    public suspend fun ruleSetVersion(`value`: Output<String>) {
        this.ruleSetVersion = value
    }

    /**
     * @param value Describes the exclusions that are applied to all rules in the set.
     */
    @JvmName("cpulskvbjuecatuc")
    public suspend fun exclusions(`value`: List<ManagedRuleExclusionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param argument Describes the exclusions that are applied to all rules in the set.
     */
    @JvmName("kixgwvslmvxfumck")
    public suspend
    fun exclusions(argument: List<suspend ManagedRuleExclusionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedRuleExclusionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument Describes the exclusions that are applied to all rules in the set.
     */
    @JvmName("bsqvmqjecfqdspoo")
    public suspend fun exclusions(
        vararg
        argument: suspend ManagedRuleExclusionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ManagedRuleExclusionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument Describes the exclusions that are applied to all rules in the set.
     */
    @JvmName("xesiwybqbjjndrxm")
    public suspend fun exclusions(argument: suspend ManagedRuleExclusionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagedRuleExclusionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param values Describes the exclusions that are applied to all rules in the set.
     */
    @JvmName("gpktdaoerkumanaw")
    public suspend fun exclusions(vararg values: ManagedRuleExclusionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param value Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("bbhebnmcnbntcepf")
    public suspend fun ruleGroupOverrides(`value`: List<FrontDoorManagedRuleGroupOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param argument Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("yplpdiqhidgivkru")
    public suspend
    fun ruleGroupOverrides(argument: List<suspend FrontDoorManagedRuleGroupOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontDoorManagedRuleGroupOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param argument Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("xukamsuxjdlgeuft")
    public suspend fun ruleGroupOverrides(
        vararg
        argument: suspend FrontDoorManagedRuleGroupOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrontDoorManagedRuleGroupOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param argument Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("lyxlyjsisnttlhhq")
    public suspend
    fun ruleGroupOverrides(argument: suspend FrontDoorManagedRuleGroupOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrontDoorManagedRuleGroupOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param values Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("fdlbdaodoqtexsak")
    public suspend fun ruleGroupOverrides(vararg values: FrontDoorManagedRuleGroupOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param value Defines the rule set action.
     */
    @JvmName("vpehkgeqoshycecp")
    public suspend fun ruleSetAction(`value`: Either<String, ManagedRuleSetActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetAction = mapped
    }

    /**
     * @param value Defines the rule set action.
     */
    @JvmName("cuewxmwxpunjauxv")
    public fun ruleSetAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedRuleSetActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetAction = mapped
    }

    /**
     * @param value Defines the rule set action.
     */
    @JvmName("rchcsrwxcupctkhw")
    public fun ruleSetAction(`value`: ManagedRuleSetActionType) {
        val toBeMapped = Either.ofRight<String, ManagedRuleSetActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetAction = mapped
    }

    /**
     * @param value Defines the rule set type to use.
     */
    @JvmName("hchteyaejgjmbmuw")
    public suspend fun ruleSetType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetType = mapped
    }

    /**
     * @param value Defines the version of the rule set to use.
     */
    @JvmName("dlnfegwwfguyijmg")
    public suspend fun ruleSetVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetVersion = mapped
    }

    internal fun build(): FrontDoorManagedRuleSetArgs = FrontDoorManagedRuleSetArgs(
        exclusions = exclusions,
        ruleGroupOverrides = ruleGroupOverrides,
        ruleSetAction = ruleSetAction,
        ruleSetType = ruleSetType ?: throw PulumiNullFieldException("ruleSetType"),
        ruleSetVersion = ruleSetVersion ?: throw PulumiNullFieldException("ruleSetVersion"),
    )
}
