@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.azurenative.network.kotlin.enums.IPVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Frontend IP address of the load balancer.
 * @property gatewayLoadBalancer The reference to gateway load balancer frontend IP.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
 * @property privateIPAddress The private IP address of the IP configuration.
 * @property privateIPAddressVersion Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
 * @property privateIPAllocationMethod The Private IP allocation method.
 * @property publicIPAddress The reference to the Public IP resource.
 * @property publicIPPrefix The reference to the Public IP Prefix resource.
 * @property subnet The reference to the subnet resource.
 * @property zones A list of availability zones denoting the IP allocated for the resource needs to come from.
 */
public data class FrontendIPConfigurationArgs(
    public val gatewayLoadBalancer: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateIPAddress: Output<String>? = null,
    public val privateIPAddressVersion: Output<Either<String, IPVersion>>? = null,
    public val privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val publicIPAddress: Output<PublicIPAddressArgs>? = null,
    public val publicIPPrefix: Output<SubResourceArgs>? = null,
    public val subnet: Output<SubnetArgs>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs =
        com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs.builder()
            .gatewayLoadBalancer(
                gatewayLoadBalancer?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .privateIPAddressVersion(
                privateIPAddressVersion?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateIPAllocationMethod(
                privateIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPAddress(publicIPAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicIPPrefix(publicIPPrefix?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FrontendIPConfigurationArgs].
 */
@PulumiTagMarker
public class FrontendIPConfigurationArgsBuilder internal constructor() {
    private var gatewayLoadBalancer: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var privateIPAddress: Output<String>? = null

    private var privateIPAddressVersion: Output<Either<String, IPVersion>>? = null

    private var privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var publicIPAddress: Output<PublicIPAddressArgs>? = null

    private var publicIPPrefix: Output<SubResourceArgs>? = null

    private var subnet: Output<SubnetArgs>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The reference to gateway load balancer frontend IP.
     */
    @JvmName("gdxxvfmmjdmbfvqo")
    public suspend fun gatewayLoadBalancer(`value`: Output<SubResourceArgs>) {
        this.gatewayLoadBalancer = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("fwqigydvxpiamonl")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("logcdhjgwxecwdjc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The private IP address of the IP configuration.
     */
    @JvmName("tekvdnbsktddfjvt")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
     */
    @JvmName("yofvinixygumaety")
    public suspend fun privateIPAddressVersion(`value`: Output<Either<String, IPVersion>>) {
        this.privateIPAddressVersion = value
    }

    /**
     * @param value The Private IP allocation method.
     */
    @JvmName("syumtpxdmcadmnsi")
    public suspend
    fun privateIPAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.privateIPAllocationMethod = value
    }

    /**
     * @param value The reference to the Public IP resource.
     */
    @JvmName("tyyeysymskirxopa")
    public suspend fun publicIPAddress(`value`: Output<PublicIPAddressArgs>) {
        this.publicIPAddress = value
    }

    /**
     * @param value The reference to the Public IP Prefix resource.
     */
    @JvmName("pgqhqcsmopsqbicl")
    public suspend fun publicIPPrefix(`value`: Output<SubResourceArgs>) {
        this.publicIPPrefix = value
    }

    /**
     * @param value The reference to the subnet resource.
     */
    @JvmName("qqfidjapxmkwbtar")
    public suspend fun subnet(`value`: Output<SubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("iarpkvqmxqtxvecr")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("mxgyroujrmninnjw")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("qdgruncnfnulyadl")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The reference to gateway load balancer frontend IP.
     */
    @JvmName("bobowiajgkmgogrl")
    public suspend fun gatewayLoadBalancer(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayLoadBalancer = mapped
    }

    /**
     * @param argument The reference to gateway load balancer frontend IP.
     */
    @JvmName("exspxeawdfxpcriw")
    public suspend fun gatewayLoadBalancer(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gatewayLoadBalancer = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gdawovvwgjcgofvh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("xfbmneqjbfteowqn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The private IP address of the IP configuration.
     */
    @JvmName("vpsntpaslkcdrsvh")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
     */
    @JvmName("gulymakeyiyfiswq")
    public suspend fun privateIPAddressVersion(`value`: Either<String, IPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
     */
    @JvmName("uauaahhxfixqnfor")
    public fun privateIPAddressVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
     */
    @JvmName("onjbqyyokhotxail")
    public fun privateIPAddressVersion(`value`: IPVersion) {
        val toBeMapped = Either.ofRight<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value The Private IP allocation method.
     */
    @JvmName("tctsvckeiyxrvvsf")
    public suspend fun privateIPAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The Private IP allocation method.
     */
    @JvmName("epfmjfcxmlnawbgd")
    public fun privateIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The Private IP allocation method.
     */
    @JvmName("koildovjnibxavtt")
    public fun privateIPAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The reference to the Public IP resource.
     */
    @JvmName("mmqnxhdsaqagwwbu")
    public suspend fun publicIPAddress(`value`: PublicIPAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddress = mapped
    }

    /**
     * @param argument The reference to the Public IP resource.
     */
    @JvmName("fgchnqpstqftfblj")
    public suspend fun publicIPAddress(argument: suspend PublicIPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddress = mapped
    }

    /**
     * @param value The reference to the Public IP Prefix resource.
     */
    @JvmName("oyiangxbwbmtxfud")
    public suspend fun publicIPPrefix(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPPrefix = mapped
    }

    /**
     * @param argument The reference to the Public IP Prefix resource.
     */
    @JvmName("vfntowmoebyndfmm")
    public suspend fun publicIPPrefix(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPPrefix = mapped
    }

    /**
     * @param value The reference to the subnet resource.
     */
    @JvmName("kbgkhipqsatsumtk")
    public suspend fun subnet(`value`: SubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The reference to the subnet resource.
     */
    @JvmName("bwmuimnpkiplajjn")
    public suspend fun subnet(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("aacqauhqrdqdfcxw")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("agrrjnnprnpeeovh")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): FrontendIPConfigurationArgs = FrontendIPConfigurationArgs(
        gatewayLoadBalancer = gatewayLoadBalancer,
        id = id,
        name = name,
        privateIPAddress = privateIPAddress,
        privateIPAddressVersion = privateIPAddressVersion,
        privateIPAllocationMethod = privateIPAllocationMethod,
        publicIPAddress = publicIPAddress,
        publicIPPrefix = publicIPPrefix,
        subnet = subnet,
        zones = zones,
    )
}
