@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetAdminRuleCollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationName The name of the network manager Security Configuration.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 * @property ruleCollectionName The name of the network manager security Configuration rule collection.
 */
public data class GetAdminRuleCollectionPlainArgs(
    public val configurationName: String,
    public val networkManagerName: String,
    public val resourceGroupName: String,
    public val ruleCollectionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetAdminRuleCollectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetAdminRuleCollectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetAdminRuleCollectionPlainArgs.builder()
            .configurationName(configurationName.let({ args0 -> args0 }))
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleCollectionName(ruleCollectionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAdminRuleCollectionPlainArgs].
 */
@PulumiTagMarker
public class GetAdminRuleCollectionPlainArgsBuilder internal constructor() {
    private var configurationName: String? = null

    private var networkManagerName: String? = null

    private var resourceGroupName: String? = null

    private var ruleCollectionName: String? = null

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("vrdtpxnfjmsuvsxl")
    public suspend fun configurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationName = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("pgsdopgqshjauxgp")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vhnktmbmwbbjgoid")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the network manager security Configuration rule collection.
     */
    @JvmName("wlhowkninisgmpym")
    public suspend fun ruleCollectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleCollectionName = mapped
    }

    internal fun build(): GetAdminRuleCollectionPlainArgs = GetAdminRuleCollectionPlainArgs(
        configurationName = configurationName ?: throw PulumiNullFieldException("configurationName"),
        networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleCollectionName = ruleCollectionName ?: throw PulumiNullFieldException("ruleCollectionName"),
    )
}
