@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetDdosCustomPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ddosCustomPolicyName The name of the DDoS custom policy.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetDdosCustomPolicyPlainArgs(
    public val ddosCustomPolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetDdosCustomPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetDdosCustomPolicyPlainArgs =
        com.pulumi.azurenative.network.inputs.GetDdosCustomPolicyPlainArgs.builder()
            .ddosCustomPolicyName(ddosCustomPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDdosCustomPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetDdosCustomPolicyPlainArgsBuilder internal constructor() {
    private var ddosCustomPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the DDoS custom policy.
     */
    @JvmName("ckxxoanpwmnxelke")
    public suspend fun ddosCustomPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ddosCustomPolicyName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xjbqikqriqlitdcu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDdosCustomPolicyPlainArgs = GetDdosCustomPolicyPlainArgs(
        ddosCustomPolicyName = ddosCustomPolicyName ?: throw
            PulumiNullFieldException("ddosCustomPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
