@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetDdosProtectionPlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ddosProtectionPlanName The name of the DDoS protection plan.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetDdosProtectionPlanPlainArgs(
    public val ddosProtectionPlanName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetDdosProtectionPlanPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetDdosProtectionPlanPlainArgs =
        com.pulumi.azurenative.network.inputs.GetDdosProtectionPlanPlainArgs.builder()
            .ddosProtectionPlanName(ddosProtectionPlanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDdosProtectionPlanPlainArgs].
 */
@PulumiTagMarker
public class GetDdosProtectionPlanPlainArgsBuilder internal constructor() {
    private var ddosProtectionPlanName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the DDoS protection plan.
     */
    @JvmName("ihakxobnnxohhayd")
    public suspend fun ddosProtectionPlanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ddosProtectionPlanName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("puupfdyjwksmdpew")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDdosProtectionPlanPlainArgs = GetDdosProtectionPlanPlainArgs(
        ddosProtectionPlanName = ddosProtectionPlanName ?: throw
            PulumiNullFieldException("ddosProtectionPlanName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
