@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property circuitName The name of the express route circuit.
 * @property connectionName The name of the express route circuit connection.
 * @property peeringName The name of the peering.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetExpressRouteCircuitConnectionPlainArgs(
    public val circuitName: String,
    public val connectionName: String,
    public val peeringName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitConnectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitConnectionPlainArgs.builder()
            .circuitName(circuitName.let({ args0 -> args0 }))
            .connectionName(connectionName.let({ args0 -> args0 }))
            .peeringName(peeringName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExpressRouteCircuitConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetExpressRouteCircuitConnectionPlainArgsBuilder internal constructor() {
    private var circuitName: String? = null

    private var connectionName: String? = null

    private var peeringName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the express route circuit.
     */
    @JvmName("wjknrlcjvifwpahs")
    public suspend fun circuitName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.circuitName = mapped
    }

    /**
     * @param value The name of the express route circuit connection.
     */
    @JvmName("rfvulncyxivsgyjs")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("qupfmyabrgkdeilr")
    public suspend fun peeringName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ahutxhrkocorkbxd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExpressRouteCircuitConnectionPlainArgs =
        GetExpressRouteCircuitConnectionPlainArgs(
            circuitName = circuitName ?: throw PulumiNullFieldException("circuitName"),
            connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
            peeringName = peeringName ?: throw PulumiNullFieldException("peeringName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
