@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitPeeringPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property circuitName The name of the express route circuit.
 * @property peeringName The name of the peering.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetExpressRouteCircuitPeeringPlainArgs(
    public val circuitName: String,
    public val peeringName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitPeeringPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitPeeringPlainArgs =
        com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitPeeringPlainArgs.builder()
            .circuitName(circuitName.let({ args0 -> args0 }))
            .peeringName(peeringName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExpressRouteCircuitPeeringPlainArgs].
 */
@PulumiTagMarker
public class GetExpressRouteCircuitPeeringPlainArgsBuilder internal constructor() {
    private var circuitName: String? = null

    private var peeringName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the express route circuit.
     */
    @JvmName("eehogvifwdgqobcm")
    public suspend fun circuitName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.circuitName = mapped
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("hpiyjioypeyqguhs")
    public suspend fun peeringName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("spmrmmtelewjqafj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExpressRouteCircuitPeeringPlainArgs =
        GetExpressRouteCircuitPeeringPlainArgs(
            circuitName = circuitName ?: throw PulumiNullFieldException("circuitName"),
            peeringName = peeringName ?: throw PulumiNullFieldException("peeringName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
