@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetExpressRouteCrossConnectionPeeringPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property crossConnectionName The name of the ExpressRouteCrossConnection.
 * @property peeringName The name of the peering.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetExpressRouteCrossConnectionPeeringPlainArgs(
    public val crossConnectionName: String,
    public val peeringName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetExpressRouteCrossConnectionPeeringPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetExpressRouteCrossConnectionPeeringPlainArgs =
        com.pulumi.azurenative.network.inputs.GetExpressRouteCrossConnectionPeeringPlainArgs.builder()
            .crossConnectionName(crossConnectionName.let({ args0 -> args0 }))
            .peeringName(peeringName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExpressRouteCrossConnectionPeeringPlainArgs].
 */
@PulumiTagMarker
public class GetExpressRouteCrossConnectionPeeringPlainArgsBuilder internal constructor() {
    private var crossConnectionName: String? = null

    private var peeringName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the ExpressRouteCrossConnection.
     */
    @JvmName("nnbqnjpwolfcaqoq")
    public suspend fun crossConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.crossConnectionName = mapped
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("auxrpwvgcsxjtifd")
    public suspend fun peeringName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wcldibsdkjqyghvc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExpressRouteCrossConnectionPeeringPlainArgs =
        GetExpressRouteCrossConnectionPeeringPlainArgs(
            crossConnectionName = crossConnectionName ?: throw PulumiNullFieldException("crossConnectionName"),
            peeringName = peeringName ?: throw PulumiNullFieldException("peeringName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
