@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetFirewallPolicyDraftPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetFirewallPolicyDraftPlainArgs(
    public val firewallPolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetFirewallPolicyDraftPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetFirewallPolicyDraftPlainArgs =
        com.pulumi.azurenative.network.inputs.GetFirewallPolicyDraftPlainArgs.builder()
            .firewallPolicyName(firewallPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirewallPolicyDraftPlainArgs].
 */
@PulumiTagMarker
public class GetFirewallPolicyDraftPlainArgsBuilder internal constructor() {
    private var firewallPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("piibwbuhmujisnxw")
    public suspend fun firewallPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xihkkikswtasdstp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFirewallPolicyDraftPlainArgs = GetFirewallPolicyDraftPlainArgs(
        firewallPolicyName = firewallPolicyName ?: throw PulumiNullFieldException("firewallPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
