@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetFirewallPolicyRuleGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property resourceGroupName The name of the resource group.
 * @property ruleGroupName The name of the FirewallPolicyRuleGroup.
 */
public data class GetFirewallPolicyRuleGroupPlainArgs(
    public val firewallPolicyName: String,
    public val resourceGroupName: String,
    public val ruleGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetFirewallPolicyRuleGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetFirewallPolicyRuleGroupPlainArgs =
        com.pulumi.azurenative.network.inputs.GetFirewallPolicyRuleGroupPlainArgs.builder()
            .firewallPolicyName(firewallPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleGroupName(ruleGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirewallPolicyRuleGroupPlainArgs].
 */
@PulumiTagMarker
public class GetFirewallPolicyRuleGroupPlainArgsBuilder internal constructor() {
    private var firewallPolicyName: String? = null

    private var resourceGroupName: String? = null

    private var ruleGroupName: String? = null

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("aqdlriijqmjvbxnk")
    public suspend fun firewallPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lgnxbvkntbonlhso")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the FirewallPolicyRuleGroup.
     */
    @JvmName("edtcrqekagaoghmb")
    public suspend fun ruleGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleGroupName = mapped
    }

    internal fun build(): GetFirewallPolicyRuleGroupPlainArgs = GetFirewallPolicyRuleGroupPlainArgs(
        firewallPolicyName = firewallPolicyName ?: throw PulumiNullFieldException("firewallPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleGroupName = ruleGroupName ?: throw PulumiNullFieldException("ruleGroupName"),
    )
}
