@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetFlowLogPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property flowLogName The name of the flow log resource.
 * @property networkWatcherName The name of the network watcher.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetFlowLogPlainArgs(
    public val flowLogName: String,
    public val networkWatcherName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetFlowLogPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetFlowLogPlainArgs =
        com.pulumi.azurenative.network.inputs.GetFlowLogPlainArgs.builder()
            .flowLogName(flowLogName.let({ args0 -> args0 }))
            .networkWatcherName(networkWatcherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFlowLogPlainArgs].
 */
@PulumiTagMarker
public class GetFlowLogPlainArgsBuilder internal constructor() {
    private var flowLogName: String? = null

    private var networkWatcherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the flow log resource.
     */
    @JvmName("fmkcwflxugjlumsj")
    public suspend fun flowLogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.flowLogName = mapped
    }

    /**
     * @param value The name of the network watcher.
     */
    @JvmName("xghngmxedtxyided")
    public suspend fun networkWatcherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkWatcherName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dfnrhghfacfstlyd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFlowLogPlainArgs = GetFlowLogPlainArgs(
        flowLogName = flowLogName ?: throw PulumiNullFieldException("flowLogName"),
        networkWatcherName = networkWatcherName ?: throw PulumiNullFieldException("networkWatcherName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
