@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetForwardingRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsForwardingRulesetName The name of the DNS forwarding ruleset.
 * @property forwardingRuleName The name of the forwarding rule.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetForwardingRulePlainArgs(
    public val dnsForwardingRulesetName: String,
    public val forwardingRuleName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetForwardingRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetForwardingRulePlainArgs =
        com.pulumi.azurenative.network.inputs.GetForwardingRulePlainArgs.builder()
            .dnsForwardingRulesetName(dnsForwardingRulesetName.let({ args0 -> args0 }))
            .forwardingRuleName(forwardingRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetForwardingRulePlainArgs].
 */
@PulumiTagMarker
public class GetForwardingRulePlainArgsBuilder internal constructor() {
    private var dnsForwardingRulesetName: String? = null

    private var forwardingRuleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the DNS forwarding ruleset.
     */
    @JvmName("cvlqloptloykenfm")
    public suspend fun dnsForwardingRulesetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dnsForwardingRulesetName = mapped
    }

    /**
     * @param value The name of the forwarding rule.
     */
    @JvmName("kaunsnewubyhgaue")
    public suspend fun forwardingRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.forwardingRuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hvjspkwahsewjrhq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetForwardingRulePlainArgs = GetForwardingRulePlainArgs(
        dnsForwardingRulesetName = dnsForwardingRulesetName ?: throw
            PulumiNullFieldException("dnsForwardingRulesetName"),
        forwardingRuleName = forwardingRuleName ?: throw PulumiNullFieldException("forwardingRuleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
