@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetHubRouteTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The resource group name of the VirtualHub.
 * @property routeTableName The name of the RouteTable.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class GetHubRouteTablePlainArgs(
    public val resourceGroupName: String,
    public val routeTableName: String,
    public val virtualHubName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetHubRouteTablePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetHubRouteTablePlainArgs =
        com.pulumi.azurenative.network.inputs.GetHubRouteTablePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .routeTableName(routeTableName.let({ args0 -> args0 }))
            .virtualHubName(virtualHubName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHubRouteTablePlainArgs].
 */
@PulumiTagMarker
public class GetHubRouteTablePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var routeTableName: String? = null

    private var virtualHubName: String? = null

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("jiarrfvstisckpwh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the RouteTable.
     */
    @JvmName("castahcncafmcgbr")
    public suspend fun routeTableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeTableName = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("utfjaubkwdsdaevb")
    public suspend fun virtualHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualHubName = mapped
    }

    internal fun build(): GetHubRouteTablePlainArgs = GetHubRouteTablePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        routeTableName = routeTableName ?: throw PulumiNullFieldException("routeTableName"),
        virtualHubName = virtualHubName ?: throw PulumiNullFieldException("virtualHubName"),
    )
}
